#include "../gintenlib/options.hpp"

// <gintenlib/options/options.hpp> の例文と同じコード
// Boost.Test でのチェックはもう少々お待ちを。

// usage: コマンド名 オプション文字列 解析させたい引数
// こう起動することにより、 options のほぼ全機能をテストできる例です
#include <gintenlib/options.hpp>
#include <gintenlib/cast.hpp>

#include <iostream>
using namespace std;

int main( int argc, char* argv[] )
{
  // 暗黙キャスト
  using gintenlib::cast;
  
  try
  {
    if( argc < 2 ){ throw gintenlib::option_error("missing 'OPTSTR'"); }
    
    // argv[1] は特別な引数
    gintenlib::options opt( argc, argv, argv[1] );
    // なので解析させない
    opt.set_optind( 2 );
    
    for(;;)
    {
      // 解析させる。 ch にはオプションの文字が入る
      int ch = opt();
      if( ch == -1 ){ break; }  // -1: 解析終わり
      
      switch(ch)
      {
       case '?':
        // ':' で始まるオプション文字列への対応
        cout << "unknown option '" << cast<char>( opt.optopt() ) << "' is given. continue...\n";
        break;
        
       case ':':
        // 同じく ':' で始まるオプション文字列への対応
        cout << "option '" << cast<char>( opt.optopt() ) << "'requires argument. continue...\n";
        break;
        
       default:
        // オプション一般
        cout << "option '" << cast<char>( ch ) << "' is given.\n";
        
        // 引数は optarg() で獲得
        // 引数が無い場合は string() が入る
        if( !opt.optarg().empty() )
        {
          cout << "  argument: " << opt.optarg() << endl;
        }
        break;
        
      }
    }
    
    // 解析終了。余ったオプションは argv[opt.optind()] から argv[argc-1] に集められる
    // デフォルトでは、オプション引数が非オプション引数の後にある場合、 argv の順序を入れ替える
    // この動作を避けたい場合は、コンストラクタの引数を '+' で始めればよい
    cout << "\nextra options are:\n";
    for( int i = opt.optind(); i < argc; ++i )
    {
      cout << argv[i] << endl;
    }
  }
  catch( gintenlib::option_error& e )
  {
    // オプション解析に失敗して例外が投げられた場合はこちらに飛ぶ
    cerr << e.what() << endl;
    cerr << "usage: " << argv[0] << " OPTSTR [OPTIONS]\n";
    
    return 1;
  }
  catch( std::exception& e )
  {
    // そのほかの例外
    cerr << e.what() << endl;
    return 1;
  }
} // main( argc, argv )
