#include "../gintenlib/move_ptr.hpp"

// 仮テストコードなので
// boost.test はまだ使わない。
// コメントも少なく非常に見難いテストですが、
// 出力とソースを見比べて何が起こってるかを把握してみてください

struct hoge
{
  // virtual implementation model
  virtual ~hoge() {}

  virtual void foo() = 0;

  // 関数の戻り値として使うことが出来る
  static gintenlib::move_ptr<hoge> create( int i );
  // static std::auto_ptr<hoge> create( int i );

};

#include <iostream>
#include <cassert>
using namespace std;

// 別の例、削除用ファンクタを用意する
struct my_deleter
{
  my_deleter( int x = 0 ) : i(x) {}
  
  template<typename T>
  void operator()( T* ptr )
  {
    cout << *this << ": deleting '" << *ptr << "'...\n";
    delete ptr;
  }
  
  friend ostream& operator<< ( ostream& os, const my_deleter& rhs )
  {
    os << "my_deleter";
    
    if( rhs.i > 0 )
    {
      os << " No." << rhs.i;
    }
    
    return os;
  }
  
  int i;
};

int main()
{
  gintenlib::move_ptr<hoge> p1, p2( hoge::create(2) );
  
  assert( !p1 );
  assert( p1 == 0 );
  assert( p2 );
  assert( p2 != 0 );
  
  assert( p1 != p2 );
  assert( !( p1 == p2 ) );
  
  gintenlib::move_ptr<hoge> p3 = p2;
  
  assert( !p2 );
  assert( p3 );
  
  swap( p1, p3 );
  
  assert( p1 );
  assert( !p3 );
  
  p1->foo();
  p1.reset();
  
  // 自作デリータを使ってみる
  gintenlib::move_ptr< int, my_deleter > p4( new int(4) ), p5( new int(5), my_deleter(2) );
  p4 = p5;
  cout << *p4 << endl;
  
  gintenlib::move_ptr< const int, my_deleter > p6( p4 );
  p4.reset( new int(4), my_deleter(3) );
  
  my_deleter del;
  cout << get_deleter(p4) << endl;
  delete p4.release( del );
  cout << del << endl;
  
  p4 = gintenlib::const_pointer_cast<int>(p6);
  assert( !p6 );
  
  cout << "scope out.\n";
}

// 本来は別ファイルに置くべきですが簡略のため。
gintenlib::move_ptr<hoge> hoge::create( int i )
{
  struct impl : hoge
  {
    explicit impl( int x = 0 ) : i(x)
    {
      cout << "hoge(" << i << ") is constructed.\n";
    }
    ~impl()
    {
      cout << "hoge(" << i << ") is destructed.\n";
    }
    
    virtual void foo()
    {
      cout << "hoge(" << i << ").foo() is called.\n";
    }
    
   private:
    int i;
  };
  
  return gintenlib::move_ptr<hoge>( new impl(i) );
}
