#include "../gintenlib/list_formatter.hpp"
#include "../gintenlib/to_string.hpp"

// boost の単体テストフレームワーク
#include <boost/test/minimal.hpp>

#include <sstream>
#include <vector>
#include <algorithm>

using namespace std;

// list_format と同じで失礼
int test_main( int, char** )
{
  // とりあえずデータを用意する
  vector<int> v;
  v.push_back( 0 );
  v.push_back( 6 );
  v.push_back( 1 );
  v.push_back( 7 );
  
  {
    ostringstream oss;
    
    // formatter オブジェクトを作る
    gintenlib::list_formatter fmt;
    // コンテナに噛ませて出力
    oss << fmt( v );
    
    BOOST_CHECK( oss.str() == "( 0, 6, 1, 7 )" );
    BOOST_CHECK( oss.str() == gintenlib::to_str( gintenlib::list_format( v.begin(), v.end() ) ) );
  }
  {
    // スタイルを変化させる場合に、少し楽になる
    ostringstream oss;
    
    // formatter オブジェクトを作るときに指定
    gintenlib::list_formatter fmt( "", " ", "" );
    // 出力部は変えなくていい
    oss << fmt( v );
    
    BOOST_CHECK( oss.str() == "0 6 1 7" );
    
    // 別のスタイルで出力
    oss.str( string() );
    // iterator を使ってみる
    copy( v.begin(), v.end(), fmt.make_iterator(oss) );
    
    BOOST_CHECK( oss.str() == "0 6 1 7" );
  }
  
  return 0;
}
