// ヘッダのインクルード
#include "../gintenlib/deleter.hpp"

// boost の単体テストフレームワーク
#include <boost/test/minimal.hpp>

#include <boost/noncopyable.hpp>

// 不完全型（後で使う）
struct incomplete_type;

// テスト用のクラス、
// 生きているオブジェクトの数を数える
class test_class
  : boost::noncopyable
{
  static int count_;
  
 public:
  test_class() { ++count_; }
  ~test_class(){ --count_; }
  
  static int use_count(){ return count_; }
  
};
int test_class::count_ = 0;

// まず deleter & dummy_deleter のテスト
void test_deleter()
{
  const int count = test_class::use_count();
  
  test_class* p = new test_class();
  BOOST_CHECK( test_class::use_count() == count + 1 );
  
  gintenlib::deleter del;
  
  // デリートっ
  del( p );
  BOOST_CHECK( test_class::use_count() == count );
  p = 0;
  del( p ); // ぬるぽに対しては何もしない
  BOOST_CHECK( test_class::use_count() == count );
  
  // そのほか、（意味は無いけど）これは動く
  del( new int() );
  // こんなのもギリギリ合法
  del( static_cast<test_class*>(0) );
  BOOST_CHECK( test_class::use_count() == count ); // カウント変化してないよ？
  
  // でもこれはダメ。不完全型の delete
  // del( static_cast<incomplete_type*>(0) );
  
  // 当然と思うでしょ、でも ↓ これだと
  // delete static_cast<incomplete_type*>(0);
  // コンパイル通っちゃうんですよ？
  // ・・・まー boost::checked_delete のおかげなんですが
  
  // じゃー dummy_deleter だとどうなる？
  p = new test_class();
  BOOST_CHECK( test_class::use_count() == count + 1 );
  // 面倒なのでその場で構築する
  gintenlib::dummy_deleter()( p );
  
  // 実際には削除されてないのでカウントは変化しない筈
  BOOST_CHECK( test_class::use_count() == count + 1 );
  
  delete p; p = 0;  // 仕方ないので手動 delete
  
  // こんなファンクタに意味有るかって？
  // あるよ。例えば boost::shared_ptr を使う場合とか。
  // 参照管理に boost::weak_ptr を使いたいけど、ポインタの削除まではして欲しくない、
  // そういうときに気軽に使えるのが dummy_deleter 。
  // いちいちその場で「何もしないファンクタ」を作るより気が利いてるでしょ？
}

// 次、 typed_deleter のテスト
// なんとなく思い立って value_saver なんて使ってみる
#include "../gintenlib/value_saver.hpp"

void test_typed_deleter()
{
  using gintenlib::value_saver;
  
  int i = 1;
  
  // value_saver を作る。
  // 機能は、デストラクタ呼び出し時に対象変数の値を復元
  value_saver* p = new value_saver(i);
  
  BOOST_CHECK( i == 1 );
  i = 2;
  BOOST_CHECK( i == 2 );
  
  gintenlib::typed_deleter<value_saver> del;
  // 削除っ
  del( p ); p = 0;
  
  // これにより巻き戻ったはず
  BOOST_CHECK( i == 1 );
  
  // まーやってることは deleter と変わりません。
  // del( new int() );
  // これが動かないくらいで。
  
  // typed_dummy_deleter も同様に
  p = new value_saver(i);
  i = 2;
  BOOST_CHECK( i == 2 );
  gintenlib::typed_dummy_deleter<value_saver>()( p );
  // ダミーなので変わらない
  BOOST_CHECK( i == 2 );
  
  // めんどいので delete もしない（ぉぃ）
}

int test_main( int, char** )
{
  test_deleter();
  test_typed_deleter();
  
  return 0;
}
