#include "../gintenlib/assign.hpp"

#include <boost/iterator/counting_iterator.hpp>
#include <boost/array.hpp>

// boost の単体テストフレームワーク
#include <boost/test/minimal.hpp>

// 基本的な動作チェック
void basic_test()
{
  static const int n = 10;
  
  int a[n];
  boost::array<int, n> b;
  
  // a を、boost::counting_iterator を使い、 0 から 9 の値で初期化
  gintenlib::assign( a, boost::counting_iterator<int>(0) );
  // チェック
  for( int i = 0; i < n; ++i )
  {
    BOOST_CHECK( a[i] == i );
  }
  
  // b を逆順に a で初期化
  gintenlib::assign( b.rbegin(), b.rend(), &a[0] );
  // チェック
  for( int i = 0, j = n - 1; i < n; ++i, --j )
  {
    BOOST_CHECK( b[i] == a[j] );
  }
}

// archetype を使ったテスト（無限ループするので呼び出しはしないこと）
#include <boost/concept_archetype.hpp>
void archetype_test()
{
  typedef boost::mutable_forward_iterator_archetype<int> forward_iterator;
  typedef boost::input_iterator_archetype<int> input_iterator;
  
  gintenlib::assign( forward_iterator(), forward_iterator(), input_iterator() );
  // range 版はなし
}

// 厳密な動作チェックは行わない

// テスト本体
int test_main( int, char** )
{
  // archetype_test();
  basic_test();
  
  return 0;
}
