#ifndef GINTENLIB_INCLUDED_SWAPPABLE_HPP_
#define GINTENLIB_INCLUDED_SWAPPABLE_HPP_

/*

      <gintenlib/swappable.hpp>

  swappable ： friend 版 swap の自動定義

  宣言：
    template< typename Derived >
    class swappable
    {
      friend void swap( Derived& one, Derived& another );
    };

  機能：
    one.swap( another ); を呼び出す friend 関数 swap を定義します
  
*/

namespace gintenlib
{
 namespace swappable_ // ADL 対策
 {
  // 使い方： class hoge : gintenlib::swappable<hoge>
  template<typename Derived>
  class swappable
  {
    friend void swap( Derived& one, Derived& another )
    {
      one.swap( another );
    }
    
  };  // struct swappable
  
 }  // namespace swappable_
 
 // ADL 対策
 using namespace swappable_;

} // namespace gintenlib

#endif  // #ifndef GINTENLIB_INCLUDED_SWAPPABLE_HPP_
