#ifndef GINTENLIB_INCLUDED_ENABLE_IF_HPP_
#define GINTENLIB_INCLUDED_ENABLE_IF_HPP_

/*

      <gintenlib/enable_if.hpp>

  enable_if ： boost::enable_if の using 宣言

  宣言：
    using boost::enable_if;
    using boost::enable_if_c;
    using boost::disable_if;
    using boost::disable_if_c;
    
  機能：
    単純に gintenlib 内で boost::enable_if を使う機会は多いので、
    予め using 宣言しておけば、いちいち boost:: と指定してやる必要が無くて楽、だけのヘッダです。
    あとは TR1 への対応をしやすいように、という意義もあります。
    その場合は互換性が失われる可能性もあるので、やるとすればメジャーバージョンアップ時でしょうが。

*/

#include <boost/utility/enable_if.hpp>

namespace gintenlib
{
  using boost::enable_if;
  using boost::enable_if_c;
  using boost::disable_if;
  using boost::disable_if_c;

}   // namespace gintenlib


#endif  // #ifndef GINTENLIB_INCLUDED_ENABLE_IF_HPP_
