#ifndef GINTENLIB_INCLUDED_CONTEXT_ERROR_HPP_
#define GINTENLIB_INCLUDED_CONTEXT_ERROR_HPP_

/*
      <gintenlib/context_error.hpp>

  context_error: 文脈エラークラス
  
  説明：
    関数などを、呼び出してはいけない状況で呼び出したときに送出される例外です。

*/

#include <stdexcept>

namespace gintenlib
{
  struct context_error
    : std::logic_error
  {
    explicit context_error( const std::string& what_ )
      : std::logic_error( what_ ) {}
    
  };  // struct context_error
  
} // namespace gintenlib

#endif  // #ifndef GINTENLIB_INCLUDED_CONTEXT_ERROR_HPP_
