package org.ginkgo.gcov.navigator;


import org.eclipse.cdt.internal.ui.cview.CView;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class Navigator extends CView {

	@Override
	public void createPartControl(Composite parent) {
		super.createPartControl(parent);
		TreeViewer aViewer = getViewer();
		createColumn(aViewer);
	}
	private void createColumn(TreeViewer aViewer) {
		TreeColumn column = new TreeColumn(aViewer.getTree(),SWT.NONE);
		column.setWidth(200);
		column.setText("Resource");

		final TreeColumn column2 = new TreeColumn(aViewer.getTree(),SWT.NONE);
		column2.setWidth(200);
		column2.setText("Coverage Ratio");
		
		IBaseLabelProvider provider = aViewer.getLabelProvider();
		CoverageLabelProvider covLabel = new CoverageLabelProvider(provider);
		aViewer.setLabelProvider(covLabel);

		aViewer.getTree().setHeaderVisible(true);
/*		OwnerDrawLabelProvider.setUpOwnerDraw(getCommonViewer());
*/
		aViewer.getTree().addListener(SWT.PaintItem, new Listener(){

			   public void handleEvent(Event event) {
			      // 3列目をグラフ表示
			      if (event.index == 1) {
			          TreeItem item = (TreeItem) event.item;
			          String text = item.getText(1);
			          if (text.equals("")) return;
			          String p = text.split("%")[0];
			          double d = Double.parseDouble(p);
			          // グラフィックコンテキスト取得
			          GC gc = event.gc;
			          // 現在の前景色、背景色を記憶
			          Color foreground = gc.getForeground();
			          Color background = gc.getBackground();

			          Tree table = (Tree) event.widget;
			          TreeColumn column = table.getColumn(1);
			      
			          int width = (int)((column.getWidth() - 1) * d / 100.0);
			          // グラフ描画
			          gc.setForeground(event.display.getSystemColor(SWT.COLOR_RED));
			          gc.fillGradientRectangle(event.x, event.y, column.getWidth(), event.height, true);

			          gc.setForeground(event.display.getSystemColor(SWT.COLOR_GREEN));
			          gc.fillGradientRectangle(event.x, event.y, width, event.height, true);
			          
			          // グラフの枠を描画
			          gc.setForeground(event.display.getSystemColor(SWT.COLOR_YELLOW));
			          Rectangle rect = new Rectangle(event.x, event.y, column.getWidth(), event.height - 1);
			          gc.drawRectangle(rect);
			          gc.setForeground(event.display.getSystemColor(SWT.COLOR_LIST_FOREGROUND));
			          // 前景色、背景色を元に戻す
			          gc.setForeground(foreground);
			          gc.setBackground(background);
			          Point labelSize = gc.textExtent(text);
			          int offset = Math.max(0, (event.height - labelSize.y) / 2);
			          gc.drawText(text, event.x+2, event.y + offset, true);
			      }
			   }
			});
	}

	public Navigator() {
		// TODO �����������ꂽ�R���X�g���N�^�[�E�X�^�u
	}

}
