/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpmypaintbrushselect_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpmypaintbrushselect
 * @title: gimpmypaintbrushselect
 * @short_description: Functions providing a mypaint brush selection dialog.
 *
 * Functions providing a mypaint brush selection dialog.
 **/


/**
 * gimp_mypaint_brushes_popup:
 * @mypaint_brush_callback: The callback PDB proc to call when mypaint brush selection is made.
 * @popup_title: Title of the mypaint brush selection dialog.
 * @initial_brush: The name of the mypaint brush to set as the first selected.
 *
 * Invokes the Gimp mypaint brush selection.
 *
 * This procedure opens the mypaint brush selection dialog.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_mypaint_brushes_popup (const gchar *mypaint_brush_callback,
                            const gchar *popup_title,
                            const gchar *initial_brush)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-mypaint-brushes-popup",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, mypaint_brush_callback,
                                    GIMP_PDB_STRING, popup_title,
                                    GIMP_PDB_STRING, initial_brush,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_mypaint_brushes_close_popup:
 * @mypaint_brush_callback: The name of the callback registered for this pop-up.
 *
 * Close the mypaint brush selection dialog.
 *
 * This procedure closes an opened brush selection dialog.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_mypaint_brushes_close_popup (const gchar *mypaint_brush_callback)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-mypaint-brushes-close-popup",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, mypaint_brush_callback,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_mypaint_brushes_set_popup:
 * @mypaint_brush_callback: The name of the callback registered for this pop-up.
 * @mypaint_brush_name: The name of the brush to set as selected.
 *
 * Sets the current mypaint brush in a mypaint brush selection dialog.
 *
 * Sets the current mypaint brush in a mypaint brush selection dialog.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_mypaint_brushes_set_popup (const gchar *mypaint_brush_callback,
                                const gchar *mypaint_brush_name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-mypaint-brushes-set-popup",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, mypaint_brush_callback,
                                    GIMP_PDB_STRING, mypaint_brush_name,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}
