unit DefaultFileManager;

{!
\file       DefaultFileManager.pas
\brief      ݒt@CǗNX
}
interface

uses
    Windows, Classes, Controls,	ComCtrls, SysUtils;

type

    TDefaultFileManager = class(TObject)
    private
        {!
        \brief      ΃pXŕԂiCXg[tH_)
        \param      Path    CXg[tH_̑΃pX
        }
        class function GetFilePath(const Path: String) : String;
        {!
        \brief		FromFile݂CToFile݂ȂꍇɃRs[
        \param		FromFile    ݒt@Czu
        \param      ToFile      zu
        }
        class procedure CopyFile(const FromFile: String; const ToFile : String);
    public
        {!
        \brief		ݒt@CwʒuɃRs[
        \param		FileName    ݒt@C̔zuwt@C
        }
        class procedure CopyDefaultFiles(const FileName: String);
    end;

implementation

uses
    IniFiles,ShellAPI, GikoSystem, MojuUtils;

class procedure TDefaultFileManager.CopyDefaultFiles(const FileName: String);
const
    FROM_KEY    = 'FROM';
    TO_KEY      = 'TO';
var
    ini : TMemIniFile;
    sections : TStringList;
    i: Integer;
begin
    if ( FileExists(FileName) ) then begin
        ini := TMemIniFile.Create( FileName );
        sections := TStringList.Create;
        try
            // ׂẴZNVǂݍ
            ini.ReadSections(sections);
            for i := 0 to sections.Count - 1 do begin
                // FROM  TOɃt@CRs[
                CopyFile( ini.ReadString(sections[i], FROM_KEY, ''),
                             ini.ReadString(sections[i], TO_KEY, '') );
            end;
        finally
            sections.Clear;
            sections.Free;
            ini.Free;
        end;
    end;

end;
class procedure TDefaultFileManager.CopyFile(
    const FromFile: String; const ToFile : String);
var
    fromPath, toPath : String;
begin
    // zuCzûǂ炩̏ꍇ͉Ȃ
    if ( (FromFile <> '') and (ToFile <> '') ) then begin
        // ../ ƂŃCXg[tH_̗̈ɃANZX
        // ̂ŒuĂ܂
        fromPath := GetFilePath( FromFile );
        toPath := GetFilePath( ToFile );
        if ( FileExists(fromPath) ) then begin
            // zuɂ牽Ȃ
            if (not FileExists(toPath)) then begin
                // zũtH_𐶐
                GikoSys.ForceDirectoriesEx(
                    ExtractFilePath(toPath));
                Windows.CopyFile( PChar(fromPath), PChar(toPath), False);
            end;
        end;
    end;

end;
class function TDefaultFileManager.GetFilePath(const Path: String): String;
begin
    Result := GikoSys.GetAppDir +
        CustomStringReplace(
            CustomStringReplace(Path, '/', '\' ), '..\', '');
end;
end.
