unit SaveFile;

interface
uses
	Classes, Windows{, SysUtils, ComCtrls, IniFiles, HTTPApp, Math,
	GikoSystem, BoardGroup, Send};

{type
	TSaveFile = class(TObject)
	private
		FBoard: TBoard;
		FThreadItem: TThreadItem;
		FSendItem: TSendItem;
		FHeader: TStringList;
		FBody: TStringList;
		FTree: TTreeView;
		FSize: Integer;
		function GetHeadServerDate(List: TStrings): TDateTime;
	public
//		procedure SaveListFile;				//Xgt@Cۑ
//		procedure SaveItemFile;				//ACet@Cۑ
//		procedure SaveRangeItemFile;	//W擾ACet@Cۑ
//		procedure SaveSendFile;				//Mς݃t@Cۑ
	published
		property Board: TBoard read FBoard write FBoard;
		property ThreadItem: TThreadItem read FThreadItem write FThreadItem;
//		property SendItem: TSendItem read FSendItem write FSendItem;
		property Header: TStringList read FHeader write FHeader;
		property Body: TStringList read FBody write FBody;
		property Tree: TTreeView read FTree write FTree;
		property Size: Integer read FSize write FSize;
	end;
}
implementation
//uses
//	Giko;
{procedure TSaveFile.SaveListFile;
var
	i, j: Integer;
	index: Integer;
	wkItem: TThreadItem;
	OldItem: TThreadItem;
	NewItem: TThreadItem;
	FileName: string;
	Title: string;
	Count: Integer;
	ItemList: TList;
	NewList: TList;
	SaveCount: Integer;
	Node: TTreeNode;
	NoCount: Integer;
	Loop: Integer;
begin
	NewList := TList.Create;
	try
		//ݒ
		Board.RoundDate := Now;
		//T[ot@C̍XVݒ
		Board.LastModified := GetHeadServerDate(Header);

		//Xgۑ擾
		SaveCount := Board.ListCount;
		if SaveCount = -1 then
			SaveCount := MaxInt;

		//ÂXg烍OACe폜
		for i := Board.Count - 1 downto 0 do
			if not Board.Items[i].IsLogFile then
				Board.Delete(i);

		//VXg쐬B
		//VXgɌÂXg̃OȂ炻VXgɒǉB
		//ÂOȂ΁AVɃXIuWFNg쐬B
		Loop := Min(Body.Count, SaveCount);
		NoCount := 0;
		for i := 0 to Loop - 1 do begin
			inc(NoCount);
			GikoSys.DivideSubject(Body[i], FileName, Title, Count);

			index := Board.GetIndex(FileName);
			if index = -1 then begin
				NewItem := TThreadItem.Create;
				NewItem.FileName := FileName;
				NewItem.Title := Title;
				NewItem.Count := Count;
				NewItem.ParentBoard := Board;
				NewItem.No := NoCount;
				NewList.Add(NewItem);
			end else begin
				Board.Items[index].Count := Count;
				Board.Items[index].No := NoCount;
				NewList.Add(Board.Items[index]);
				Board.DeleteList(index);
			end;
		end;

		//VXgɖÂOLACeVXgɒǉ
		for i := 0 to Board.Count - 1 do begin
			inc(NoCount);
			Board.Items[i].No := NoCount;
			NewList.Add(Board.Items[i]);
		end;

		//ÂXgiXĝ݁BXIuWFNĝ͏Ȃj
		for i := Board.Count - 1 downto 0 do
			Board.DeleteList(i);

		//VXg{[hIuWFNgɒǉ
		for i := 0 to NewList.Count - 1 do
			Board.Add(TThreadItem(NewList[i]));

		//Xg(subject.txt)ۑ
		GikoSys.ForceDirectoriesEx(GikoSys.GetLogDir + Board.BBSID);
		Body.SaveToFile(GikoSys.GetSubjectFileName(Board.BBSID));

		GikoSys.ExitWrite.Add(Board.BBSID);
	finally
		NewList.Free;
	end;

end;}

{procedure TSaveFile.SaveItemFile;
var
//	Node: TTreeNode;
//	fNode: TTreeNode;
	Cnt: Integer;
begin
	Body.SaveToFile(GikoSys.GetThreadFileName(ThreadItem.ParentBoard.BBSID, ThreadItem.FileName));

	ThreadItem.RoundDate := Now;
	ThreadItem.Size := Size;
	ThreadItem.LastModified := GetHeadServerDate(Header);
	ThreadItem.Count := Body.Count;
	ThreadItem.IsLogFile := True;
	ThreadItem.NewReceive := 0;
//	ThreadItem.NonRead := True;

	if ThreadItem.RoundNo = 6 then
		ThreadItem.RoundNo := 0;

	GikoSys.ExitWrite.Add(ThreadItem.ParentBoard.BBSID);
end;}

{procedure TSaveFile.SaveRangeItemFile;
var
	wkBody: TStringList;
	Node: TTreeNode;
	fNode: TTreeNode;
	Cnt: Integer;
	OldCnt: Integer;
begin
	if FileExists(GikoSys.GetThreadFileName(ThreadItem.ParentBoard.BBSID, ThreadItem.FileName)) then begin
		wkBody := TStringList.Create;
		try
			wkBody.LoadFromFile(GikoSys.GetThreadFileName(ThreadItem.ParentBoard.BBSID, ThreadItem.FileName));
			wkBody.AddStrings(Body);
			wkBody.SaveToFile(GikoSys.GetThreadFileName(ThreadItem.ParentBoard.BBSID, ThreadItem.FileName));
		finally
			wkBody.Free;
		end;
	end else begin
		Body.SaveToFile(GikoSys.GetThreadFileName(ThreadItem.ParentBoard.BBSID, ThreadItem.FileName));
	end;

	OldCnt := ThreadItem.Count;

	ThreadItem.RoundDate := Now;
	ThreadItem.Size := ThreadItem.Size + Size;
	ThreadItem.LastModified := GetHeadServerDate(Header);
	ThreadItem.Count := ThreadItem.Count + Body.Count;
	ThreadItem.IsLogFile := True;
	ThreadItem.NewReceive := OldCnt + 1;
//	ThreadItem.NonRead := True;
	if ThreadItem.RoundNo = 6 then
		ThreadItem.RoundNo := 0;

	GikoSys.ExitWrite.Add(ThreadItem.ParentBoard.BBSID);
end;}

{function TSaveFile.GetHeadServerDate(List: TStrings): TDateTime;
var
	i: Integer;
	DateStr: string;
begin
	DateStr := '';
	for i := 0 to List.Count - 1 do begin
		if Pos('Date: ', List.Strings[i]) <> 0 then begin
			DateStr := StringReplace(List.Strings[i], 'Date: ', '', [rfReplaceAll]);
			Break;
		end;
	end;
//	Result := GikoSys.RFC1123ToDate(DateStr);
	Result := ParseDate(DateStr);
end;}

{procedure TSaveFile.SaveSendFile;
var
	sDate: string;
	ini: TMemIniFile;
begin
	ini := TMemIniFile.Create(GikoSys.GetSentFileName);
	try
		sDate := SendItem.StrSendDate;
		if Trim(sDate) = '' then
			sDate := GikoSys.Get2chDate(Now);

		ini.WriteString(sDate, 'Title', SendItem.Title);
		ini.WriteString(sDate, 'Name', SendItem.Name);
		ini.WriteString(sDate, 'EMail', SendItem.EMail);
		ini.WriteString(sDate, 'Body', HttpEncode(SendItem.Body));
		ini.WriteInteger(sDate, 'Status', SendItem.StatusCode);
		ini.WriteDateTime(sDate, 'Date', SendItem.SendDate);
		ini.WriteString(sDate, 'BBS', SendItem.ThreadItem.ParentBoard.BBSID);
		ini.WriteString(sDate, 'Key', ChangeFileExt(SendItem.ThreadItem.FileName, ''));

		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;
}
end.
