unit Favorite;

interface

uses
	Messages, SysUtils, Classes, Contnrs, ComCtrls, {HttpApp,} YofUtils,
	GikoSystem{, XMLIntf, XMLDoc}, GikoXMLDoc, BoardGroup, windows;
	{SAX, SAXHelpers, SAXComps, SAXKW;}

type
	TFavoriteFolder = class
	end;

	TFavoriteItem = class(TObject)
	private
		FURL				: string;
		FTitle			: string;
	public
		function GetItemTitle : string; virtual;abstract;
		property URL				: string	read FURL write FURL;	// Item 擾łȂĂ URL ͏ɕێ
		property Title			: string	read FTitle write FTitle;
	end;
	TFavoriteBoardItem = class(TFavoriteItem)
	private
		FItem				: TBoard;
		function	GetItem : TBoard;
	public
		constructor Create( inURL : string; inTitle : string = ''; inItem : TBoard = nil );
		constructor CreateWithItem( inItem : TBoard );
		destructor Destory;
		function GetItemTitle : string; override;
		property Item				: TBoard	read GetItem write FItem;
	end;

	TFavoriteThreadItem = class(TFavoriteItem)
	private
		FItem				: TThreadItem;
		function	GetItem : TThreadItem;
	public
		constructor Create( inURL : string; inTitle : string = ''; inItem : TThreadItem = nil );
		constructor CreateWithItem( inItem : TThreadItem );
		destructor Destory;
		function GetItemTitle : string; override;
		property Item				: TThreadItem	read GetItem write FItem;
	end;

	TFavoriteDM = class(TDataModule)
		procedure DataModuleDestroy(Sender: TObject);
	private
		{ Private 錾 }
		FStack: TStack;
		FTreeView: TTreeView;
		FModified: boolean;
		procedure ReadNode(Node: IXMLNode);
		procedure AddSaveString(Node: TTreeNode; SaveList: TStringList);
//		procedure AddSaveString(Node: TTreeNode; XMLNode: IXMLNode);
//		procedure SAXStartDocument(Sender: TObject);
//		procedure SAXEndDocument(Sender: TObject);
//		procedure SAXStartElement(Sender: TObject; const NamespaceURI, LocalName, QName: SAXString; const Atts: IAttributes);
//		procedure SAXEndElement(Sender: TObject; const NamespaceURI, LocalName, QName: SAXString);
//		procedure SAXCharacters(Sender: TObject; const PCh: SAXString);
	public
		{ Public 錾 }
		procedure Clear;
		function GetFavoriteFilePath() : String;
		function SaveFavoriteFile(FileName: String) : Boolean;
		procedure SetFavTreeView(TreeView: TTreeView);
		procedure ReadFavorite;
		procedure WriteFavorite;
		procedure URLReplace(oldURLs: TStringList; newURLs: TStringList);
		property TreeView: TTreeView read FTreeView;
		property Modified: boolean read FModified write FModified;
	end;

var
	FavoriteDM: TFavoriteDM;
const
	FAVORITE_LINK_NAME = 'N';

implementation

uses	ExternalBoardManager, ExternalBoardPlugInMain,  MojuUtils;

const
	FAVORITE_ROOT_NAME = 'Cɓ';
	FAVORITE_FILE_NAME = 'Favorite.xml';

{$R *.dfm}

constructor TFavoriteBoardItem.Create(
	inURL		: string;
	inTitle	: string = '';
	inItem	: TBoard = nil
);
begin

	inherited Create;

	URL		:= inURL;
	Title	:= inTitle;
	Item	:= inItem;

end;

constructor TFavoriteBoardItem.CreateWithItem(
	inItem	: TBoard
);
begin

	Create( inItem.URL, inItem.Title, inItem );

end;
destructor TFavoriteBoardItem.Destory;
begin
	if FItem <> nil then
		FItem.Free;
	inherited;
end;
//! ێĂ̃^CgԂ
function TFavoriteBoardItem.GetItemTitle : string;
begin
	Result := '';
	//xJĂȂƂiNɃLrlbgCɓƂj
	//̂ƂFItemnilȂ̂ł̂Ƃׂ͂ƌ
	if FItem = nil then begin
		FItem := BBSsFindBoardFromURL(URL);
	end;
	if FItem <> nil then begin
		try
			if not FItem.IsThreadDatRead then begin
				GikoSys.ReadSubjectFile(FItem);
			end;
		except
		end;
		Result := FItem.Title;
	end;
end;
function	TFavoriteBoardItem.GetItem : TBoard;
var
	protocol, host, path, document, port, bookmark : string;
	BBSID	: string;
	tmpURL	: string;
begin

	if FItem = nil then begin
		FItem := BBSsFindBoardFromURL( URL );
		if FItem = nil then begin
			tmpURL := URL;
			GikoSys.ParseURI( tmpURL, protocol, host, path, document, port, bookmark );
			if GikoSys.Is2chHost( host ) then begin
				BBSID := GikoSys.URLToID( tmpURL );
				FItem := BBSs[ 0 ].FindBBSID( BBSID );
				if FItem <> nil then
					URL := FItem.URL;
			end;
			{
			// ĂAǉJeŜŌۗ
			FItem				:= GikoSys.GetUnknownBoard( nil, URL );
			FItem.Title	:= Title;
			}
		end;
	end;

	Result := FItem;

end;

constructor TFavoriteThreadItem.Create(
	inURL		: string;
	inTitle	: string = '';
	inItem	: TThreadItem = nil
);
begin

	inherited Create;
	URL		:= inURL;

	Title	:= inTitle;
	Item	:= inItem;

end;

constructor TFavoriteThreadItem.CreateWithItem(
	inItem	: TThreadItem
);
begin

	Create( inItem.URL, inItem.Title, inItem );

end;
destructor TFavoriteThreadItem.Destory;
begin
	if FItem <> nil then
    	FItem.Free;
    inherited;
end;
//! ێĂX̃^CgԂ
function TFavoriteThreadItem.GetItemTitle : string;
begin
	Result := '';
	if FItem = nil then begin
		FItem := BBSsFindThreadFromURL(URL);
	end;
	if FItem <> nil then begin
		Result := FItem.Title;
	end;
end;

function	TFavoriteThreadItem.GetItem : TThreadItem;
var
	board					: TBoard;
	boardURL			: string;
	browsableURL	: string;
	protocol, host, path, document, port, bookmark : string;
	BBSID, BBSKey	: string;
	tmpURL				: string;
begin

	Result := nil;
	if FItem = nil then begin
		browsableURL	:= GikoSys.GetBrowsableThreadURL( URL );
		boardURL			:= GikoSys.GetThreadURL2BoardURL( browsableURL );
		board					:= BBSsFindBoardFromURL( boardURL );

		if board = nil then begin
			tmpURL := URL;
			GikoSys.ParseURI( tmpURL, protocol, host, path, document, port, bookmark );
			if GikoSys.Is2chHost( host ) then begin
				GikoSys.Parse2chURL( tmpURL, path, document, BBSID, BBSKey );
				board := BBSs[ 0 ].FindBBSID( BBSID );
			end;

			if board = nil then begin
				Exit;
				// ĂAǉJeŜŌۗ
				//board := GikoSys.GetUnknownBoard( nil, boardURL )
			end;
		end;

		FItem := board.FindThreadFromURL( browsableURL );

		if FItem = nil then begin
			tmpURL := URL;
			GikoSys.ParseURI( tmpURL, protocol, host, path, document, port, bookmark );
			if GikoSys.Is2chHost( host ) then begin
				GikoSys.Parse2chURL( tmpURL, path, document, BBSID, BBSKey );
				FItem := BBSs[ 0 ].FindThreadItem( BBSID, BBSKey + '.dat' );
				if FItem <> nil then
					URL := FItem.URL;
			end;
		end;

		if FItem = nil then begin
			FItem := TThreadItem.Create( board.BoardPlugIn, board, browsableURL );

			FItem.Title := Title;
			board.Add( FItem );
		end;
	end;

 	Result := FItem;

end;

procedure TFavoriteDM.DataModuleDestroy(Sender: TObject);
//var
//	i: Integer;
begin
{    TreeView.Items.BeginUpdate;
	for i := TreeView.Items.Count - 1 downto 0 do begin
	   //	if TObject(TreeView.Items[i].Data) <> nil then
       // 	TObject(TreeView.Items[i].Data).Free;
	end;
    TreeView.Items.Clear;
    TreeView.Items.EndUpdate;
}    //TreeView.Free;
end;
procedure TFavoriteDM.Clear;
var
	Node	: TTreeNode;
begin
	TreeView.Items.BeginUpdate;
	Node	:= TreeView.Items.GetFirstNode;
	while Node <> nil do begin
		if TObject(Node.Data) <> nil then
				TObject(Node.Data).Free;
		Node := Node.GetNext;
	end;
		TreeView.Items.Clear;
		TreeView.Items.EndUpdate;

    FavoriteDM.Modified := true;
end;

procedure TFavoriteDM.SetFavTreeView(TreeView: TTreeView);
begin
	FTreeView := TreeView;
end;

procedure TFavoriteDM.ReadFavorite;
var
	FileName: string;
	XMLDoc: IXMLDocument;
	XMLNode: IXMLNode;
	Node: TTreeNode;
	i: Integer;
	FavFolder: TFavoriteFolder;
	LinkExists: Boolean;
begin
	FavoriteDM.Modified := true;
	FileName := GikoSys.GetConfigDir + FAVORITE_FILE_NAME;

	FavFolder := TFavoriteFolder.Create;
	Node := FTreeView.Items.AddChildObjectFirst(nil, FAVORITE_ROOT_NAME, FavFolder);
	Node.ImageIndex := 14;
	Node.SelectedIndex := 14;

	if FileExists(FileName) then begin
		try
            XMLDoc := IXMLDocument.Create;
			//XMLDoc := LoadXMLDocument(FileName);
            LoadXMLDocument(FileName, XMLDoc);
			XMLNode := XMLDoc.DocumentElement;

			FStack := TStack.Create;
			try
				FStack.Push(Node);
				LinkExists := False;
				if XMLNode.NodeName = 'favorite' then begin
					for i := XMLNode.ChildNodes.Count - 1 downto 0 do begin
						ReadNode(XMLNode.ChildNodes[i]);
						if (XMLNode.ChildNodes[i].NodeName = 'folder') and
							 (XMLNode.ChildNodes[i].Attributes['title'] = FAVORITE_LINK_NAME) then begin
							LinkExists := True;
						end;
					end;
				end;
				if not LinkExists then begin
					FavFolder := TFavoriteFolder.Create;
					Node := FTreeView.Items.AddChildObjectFirst(Node, FAVORITE_LINK_NAME, FavFolder);
					Node.ImageIndex := 14;
					Node.SelectedIndex := 14;
				end;
			finally
				FStack.Free;
                XMLDoc.Free;
			end;
		except
		end;
	end;

{
	FavFolder := TFavoriteFolder.Create;
	Node := FTreeView.Items.AddChildObjectFirst(nil, FAVORITE_ROOT_NAME, FavFolder);
	Node.ImageIndex := 12;
	Node.SelectedIndex := 13;

	FileName := GikoSys.GetConfigDir + FAVORITE_FILE_NAME;
	if not FileExists(FileName) then
		Exit;

		FavSAXHandler.OnStartDocument := SAXStartDocument;
		FavSAXHandler.OnEndDocument := SAXEndDocument;
		FavSAXHandler.OnStartElement := SAXStartElement;
		FavSAXHandler.OnStartElement := SAXStartElement;
		FavSAXHandler.OnEndElement := SAXEndElement;
		FavSAXHandler.OnCharacters := SAXCharacters;

		FavSAXReader.Vendor := 'Keith Wood';
		FavSAXReader.URL := FileName;
		FavSAXReader.Parse;}
end;

procedure TFavoriteDM.ReadNode(Node: IXMLNode);
var
	i: Integer;

	ParentNode: TTreeNode;
	CurrentNode: TTreeNode;
	FavFolder: TFavoriteFolder;
	FavBoard: TFavoriteBoardItem;
	FavThread: TFavoriteThreadItem;
	board				: TBoard;
	threadItem	: TThreadItem;
begin
	if Node.NodeName = 'folder' then begin
		ParentNode := FStack.Peek;
		if TObject(ParentNode.Data) is TFavoriteFolder then begin
			FavFolder := TFavoriteFolder.Create;
			CurrentNode := FTreeView.Items.AddChildObjectFirst(ParentNode, Node.Attributes['title'], FavFolder);
			CurrentNode.ImageIndex := 14;
			CurrentNode.SelectedIndex := 14;
			FStack.Push(CurrentNode);
		end;
		for i := Node.ChildNodes.Count - 1 downto 0 do begin
			ReadNode(Node.ChildNodes[i]);
		end;
		if TObject(ParentNode.Data) is TFavoriteFolder then
			CurrentNode.Expanded := Node.Attributes[ 'expanded' ] = 'true';
		if FStack.Count <> 0 then
			FStack.Pop;
	end else if Node.NodeName = 'favitem' then begin
		try
			ParentNode := FStack.Peek;
			if TObject(ParentNode.Data) is TFavoriteFolder then begin
				if Node.Attributes['favtype'] = 'board' then begin
					FavBoard := nil;
					// ̂CɓƂ̌݊̂
					if Length( Node.Attributes[ 'bbs' ] ) > 0 then begin
						board := BBSsFindBoardFromBBSID( Node.Attributes[ 'bbs' ] );
						if board <> nil then
							FavBoard := TFavoriteBoardItem.Create(
								board.URL, Node.Attributes[ 'title' ], board );
					end else begin
						FavBoard := TFavoriteBoardItem.Create(
							Node.Attributes[ 'url' ], Node.Attributes[ 'title' ], nil );
					end;
					CurrentNode := FTreeView.Items.AddChildObjectFirst(ParentNode, Node.Attributes['title'], FavBoard);
					CurrentNode.ImageIndex := 15;
					CurrentNode.SelectedIndex := 15;
				end else if Node.Attributes['favtype'] = 'thread' then begin
					// ̂CɓƂ̌݊̂
					if Length( Node.Attributes[ 'bbs' ] ) > 0 then begin
						board := BBSsFindBoardFromBBSID( Node.Attributes[ 'bbs' ] );
						if board = nil then
							Exit;

						if not board.IsThreadDatRead then
							GikoSys.ReadSubjectFile( board );
						threadItem := board.FindThreadFromFileName( Node.Attributes[ 'thread' ] );
						if threadItem = nil then begin
							threadItem := TThreadItem.Create(
								board.BoardPlugIn,
                                board,
								GikoSys.Get2chBoard2ThreadURL( board, ChangeFileExt( Node.Attributes[ 'thread' ], '' ) ) );
							threadItem.Title := Node.Attributes[ 'title' ];
							board.Add( threadItem );
						end;
						FavThread := TFavoriteThreadItem.Create(
							threadItem.URL, Node.Attributes[ 'title' ], threadItem );
                        threadItem.Free;
					end else begin
						FavThread := TFavoriteThreadItem.Create(
							Node.Attributes[ 'url' ], Node.Attributes[ 'title' ], nil );
					end;
					CurrentNode := FTreeView.Items.AddChildObjectFirst(ParentNode, Node.Attributes['title'], FavThread);
					CurrentNode.ImageIndex := 16;
					CurrentNode.SelectedIndex := 16;
				end;
			end;
		except
			// ̃ACeŖ肪NẴACeɉe^Ȃ̂
		end;
	end;
end;

procedure TFavoriteDM.WriteFavorite;
{
var
	FileName: string;
//	SaveList: TStringList;
//	i: Integer;
//	Count: Integer;

	XMLDoc: IXMLDocument;
	XMLNode: IXMLNode;
//	FavoNode: IXMLNode;
begin
	XMLDoc :=	NewXMLDocument;
	XMLDoc.Encoding := 'Shift_JIS';
	XMLDoc.StandAlone := 'yes';
	XMLNode := XMLDoc.AddChild('favorite');
	FileName := GikoSys.GetConfigDir + FAVORITE_FILE_NAME;
	AddSaveString(TreeView.Items.GetFirstNode, XMLNode);
	XMLDoc.SaveToFile(FileName);
}
var
	FileName, tmpFileName: string;
	SaveList: TStringList;

begin
    FavoriteDM.Modified := true;
	FileName := GikoSys.GetConfigDir + FAVORITE_FILE_NAME;
	if FileExists(FileName) then begin
		tmpFileName := GikoSys.GetConfigDir + '~' + FAVORITE_FILE_NAME;
		if FileExists(tmpFileName) then
			SysUtils.DeleteFile(tmpFileName); //SysUtils.ȂWinAPIƋʂłȂ̂
		RenameFile(FileName, tmpFileName);
	end;
	SaveList := TStringList.Create;
	try
		SaveList.Add('<?xml version="1.0" encoding="Shift_JIS" standalone="yes"?>');
		SaveList.Add('<favorite>');
		try
			AddSaveString(TreeView.Items.GetFirstNode.getFirstChild, SaveList);
		except
		end;
		SaveList.Add('</favorite>');
		SaveList.SaveToFile(FileName);
	finally
		SaveList.Free;
	end;
end;

{
procedure TFavoriteDM.AddSaveString(Node: TTreeNode; XMLNode: IXMLNode);
var
	i: Integer;
//	s: string;
	FavBoard: TFavoriteBoardItem;
	FavThread: TFavoriteThreadItem;
	FavNode: IXMLNode;
begin
	for i := 0 to Node.Count - 1 do begin
		if TObject(Node.Item[i].Data) is TFavoriteFolder then begin
			FavNode := XMLNode.AddChild('folder');
			FavNode.Attributes['title'] := Node.Item[i].Text;
			AddSaveString(Node.Item[i], FavNode);
		end else if TObject(Node.Item[i].Data) is TFavoriteBoardItem then begin
			FavBoard := TFavoriteBoardItem(Node.Item[i].Data);
			FavNode := XMLNode.AddChild('favitem');
			FavNode.Attributes['type'] := '2ch';
			FavNode.Attributes['favtype'] := 'board';
			FavNode.Attributes['bbs'] := FavBoard.BBSID;
			FavNode.Attributes['title'] := Node.Item[i].Text;
			FavNode.Attributes['boardname'] := FavBoard.BoardName;
		end else if TObject(Node.Item[i].Data) is TFavoriteThreadItem then begin
			FavThread := TFavoriteThreadItem(Node.Item[i].Data);
			FavNode := XMLNode.AddChild('favitem');
			FavNode.Attributes['type'] := '2ch';
			FavNode.Attributes['favtype'] := 'thread';
			FavNode.Attributes['bbs'] := FavThread.BBSID;
			FavNode.Attributes['thread'] := FavThread.ThreadID;
			FavNode.Attributes['title'] := Node.Item[i].Text;
			FavNode.Attributes['threadname'] := FavThread.ThreadName;
		end;
	end;
end;
}

procedure TFavoriteDM.AddSaveString(Node: TTreeNode; SaveList: TStringList);
var
	s: string;
	FavBoard: TFavoriteBoardItem;
	FavThread: TFavoriteThreadItem;
	data : Pointer;
begin
	while Node <> nil do begin
		data := Node.Data;
		if TObject(data) is TFavoriteFolder then begin
			if Node.Expanded then
				s := Format('<folder title="%s" expanded="true">', [HtmlEncode(Node.Text)])
			else
				s := Format('<folder title="%s" expanded="false">', [HtmlEncode(Node.Text)]);
			SaveList.Add(s);
			AddSaveString(Node.getFirstChild, SaveList);
			SaveList.Add('</folder>');
		end else if TObject(data) is TFavoriteBoardItem then begin
			FavBoard := TFavoriteBoardItem(data);
			s := Format('<favitem type="2ch" favtype="board" url="%s" title="%s"/>',
									[HtmlEncode( FavBoard.URL ), HtmlEncode(Node.Text)]);
			SaveList.Add(s);
		end else if TObject(data) is TFavoriteThreadItem then begin
			FavThread := TFavoriteThreadItem(data);
			s := Format('<favitem type="2ch" favtype="thread" url="%s" title="%s"/>',
									[HtmlEncode( FavThread.URL ), HtmlEncode(Node.Text)]);
			SaveList.Add(s);
		end;
		Node := Node.getNextSibling;
	end;
end;

{
procedure TFavoriteDM.SAXStartDocument(Sender: TObject);
begin
	FStack := TStack.Create;
	FStack.Push(FTreeView.Items.GetFirstNode);
end;

procedure TFavoriteDM.SAXEndDocument(Sender: TObject);
begin
	FStack.Free;
end;

procedure TFavoriteDM.SAXStartElement(Sender: TObject; const NamespaceURI, LocalName, QName: SAXString;
	const Atts: IAttributes);
var
	FavType: string;
	ParentNode: TTreeNode;
	CurrentNode: TTreeNode;
	FavFolder: TFavoriteFolder;
	FavBoard: TFavoriteBoardItem;
	FavThread: TFavoriteThreadItem;
begin
	if QName = 'folder' then begin
		ParentNode := FStack.Peek;
		if TObject(ParentNode.Data) is TFavoriteFolder then begin
			FavFolder := TFavoriteFolder.Create;
			CurrentNode := FTreeView.Items.AddChildObject(ParentNode, Atts.getValue('title'), FavFolder);
			CurrentNode.ImageIndex := 12;
			CurrentNode.SelectedIndex := 13;
			FStack.Push(CurrentNode);
		end;
	end else if QName = 'favitem' then begin
		ParentNode := FStack.Peek;
		if TObject(ParentNode.Data) is TFavoriteFolder then begin
			FavType := Atts.getValue('favtype');
			if FavType = 'board' then begin
				FavBoard := TFavoriteBoardItem.Create;
				FavBoard.BBSID := Atts.getValue('bbs');
				FavBoard.BoardName := Atts.getValue('boardname');
				CurrentNode := FTreeView.Items.AddChildObject(ParentNode, Atts.getValue('title'), FavBoard);
				CurrentNode.ImageIndex := 14;
				CurrentNode.SelectedIndex := 15;
			end else if FavType = 'thread' then begin
				FavThread := TFavoriteThreadItem.Create;
				FavThread.BBSID := Atts.getValue('bbs');
				FavThread.ThreadID := Atts.getValue('thread');
				FavThread.ThreadName := Atts.getValue('threadname');
				CurrentNode := FTreeView.Items.AddChildObject(ParentNode, Atts.getValue('title'), FavThread);
				CurrentNode.ImageIndex := 16;
				CurrentNode.SelectedIndex := 17;
			end;
		end;
	end;
end;

procedure TFavoriteDM.SAXEndElement(Sender: TObject; const NamespaceURI, LocalName, QName: SAXString);
begin
	if QName = 'folder' then begin
		if FStack.Count <> 0 then
			FStack.Pop;
	end;
end;

procedure TFavoriteDM.SAXCharacters(Sender: TObject; const PCh: SAXString);
begin
//
end;
}
function TFavoriteDM.SaveFavoriteFile(FileName: String) : Boolean;
var
	FavoriteFilePath: string;
		tempStringList: TStringList;
begin
   	WriteFavorite;
	FavoriteFilePath := GikoSys.GetConfigDir + FAVORITE_FILE_NAME;

	if FileExists( FavoriteFilePath ) then begin
		tempStringList := TStringList.Create;
		try
			tempStringList.LoadFromFile( FavoriteFilePath );
			tempStringList.SaveToFile( FileName );
		finally
			tempStringList.Free;
		end;
		Result := true;
	end else begin
		Result := false;
	end;
end;

procedure TFavoriteDM.URLReplace(oldURLs: TStringList; newURLs: TStringList);
var
	i					: Integer;
		tmpURL: string;
    oldHost: string;
    oldBoardName: string;
    newHost: string;
    newBoardName: string;
		tempString: string;
	favBoard	: TFavoriteBoardItem;
	favThread	: TFavoriteThreadItem;
	favorites	: TTreeNodes;
	Node			: TTreeNode;
begin

	// ʓ|thread͂ꂼURL`FbNȂĂȂႢȂB
	favorites := FavoriteDM.FTreeView.Items;
	for i := 0 to oldURLs.Count - 1 do begin
		try
			tmpURL 			:= Copy(oldURLs[i], 1, Length(oldURLs[i]) -1);
			oldHost			:= Copy(tmpURL, 1, LastDelimiter('/', tmpURL) );
			oldBoardName    := Copy(tmpURL, LastDelimiter('/', tmpURL), Length(tmpURL) ) + '/';
			tmpURL 			:= Copy(newURLs[i], 1, Length(newURLs[i]) -1);
			newHost			:= Copy(tmpURL, 1, LastDelimiter('/', tmpURL) );
			newBoardName    := Copy(tmpURL, LastDelimiter('/', tmpURL), Length(tmpURL) ) + '/';

			Node := favorites.GetFirstNode.getFirstChild;
			while Node <> nil do begin
				try
					if TObject( Node.Data ) is TFavoriteBoardItem then begin
						favBoard := TFavoriteBoardItem( Node.Data );
						if favBoard = nil then continue;
						tempString := favBoard.URL;
						if ( AnsiPos(oldBoardName, tempString) <> 0 ) and ( AnsiPos(oldHost, tempString ) <> 0 ) then begin
							tempString		:= StringReplace(tempString, oldHost, newHost,[]);
							favBoard.URL	:= tempString;
						end;
					end else if TObject( Node.Data ) is TFavoriteThreadItem then begin
						favThread := TFavoriteThreadItem( Node.Data );
						if favThread = nil then continue;
						tempString := favThread.URL;
						if ( AnsiPos(oldBoardName, tempString) <> 0 ) and ( AnsiPos(oldHost, tempString ) <> 0 ) then begin
							tempString		:= StringReplace(tempString, oldHost, newHost,[]);
							favThread.URL	:= tempString;
						end;
					end;
				except
				end;
				Node := Node.GetNext;
			end;
		except
		end;
	end;

end;

function TFavoriteDM.GetFavoriteFilePath() : String;
begin
	Result := GikoSys.GetConfigDir + FAVORITE_FILE_NAME;
end;

end.
