package ogakisoft.gesture.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import ogakisoft.util.LOG;

public class SplitData {
	private static final String TAG = "SplitData";
	// private static final String converted_file =
	// "/Users/ogakinoritoshi/Documents/temp/tomoe_gestures";
//	private static final String source_file = "/Users/ogakinoritoshi/Documents/temp/gesture_data.all";
	private static final String source_file = "/Users/ogakinoritoshi/Documents/temp/gesture_data.compact";
	private static final String split_file_dir = "/Users/ogakinoritoshi/Documents/temp/";
	private static final int MAX_NUM_OF_ENTRIES = 500;
	private static Comparator<GestureHolder.Entry> mSorter = new Comparator<GestureHolder.Entry>() {
		public int compare(GestureHolder.Entry object1,
				GestureHolder.Entry object2) {
			int result = 0;
//			int s1 = 0;
//			int s2 = 0;
//			int count = 0;
//			count = object1.gestures.size();
//			for (int i = 0; i < count; i++) {
//				s1 += object1.gestures.get(i).strokes.size();
//			}
//			count = object2.gestures.size();
//			for (int i = 0; i < count; i++) {
//				s2 += object2.gestures.get(i).strokes.size();
//			}
//			if (s1 < s2)
//				result = -1;
//			else if (s1 > s2)
//				result = 1;
//			else if (s1 == s2)
				result = object1.entryName.compareTo(object2.entryName);
			return result;
		}
	};

	public static void main(String[] args) {
		LoadGesture load = new LoadGesture();
		SaveGesture save = new SaveGesture();
		FileInputStream fi = null;
		FileOutputStream fo = null;
		final GestureHolder holder = new GestureHolder();
		final List<GestureHolder.Entry> entries;
		GestureHolder result_holder = null;
		GestureHolder.Entry entry;
		int save_count = 1;
		try {
			// load.loadFilter();
			fi = new FileInputStream(new File(source_file));
			load.load(fi, holder);

			entries = holder.getEntries();
			int count = entries.size();
			Collections.sort(entries, mSorter);

			for (int i = 0; i < count; i += MAX_NUM_OF_ENTRIES) {
				int start_entry_pos = i;
				int last_entry_pos = i + MAX_NUM_OF_ENTRIES;
				LOG.d(TAG, "split f={0,number,#},t={1,number,#}",
						start_entry_pos, last_entry_pos - 1);
				result_holder = new GestureHolder();
				for (int j = start_entry_pos; j < last_entry_pos && j < count; j++) {
					entry = entries.get(j);
					result_holder.addEntry(entry);
				}
				fo = new FileOutputStream(new File(split_file_dir,
						"gesture_data." + String.valueOf(save_count++)));
				save.save(fo, result_holder);
				fo.close();
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (null != fi)
					fi.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

}
