package ogakisoft.tomoe;

import java.util.ArrayList;

public class Strokes {
    private ArrayList<Stroke> stroke;

    public Strokes(){
        stroke = new ArrayList<Stroke>(0);
    }

    public int getSize() {
        stroke.trimToSize();
        return stroke.size();
    }

    public Stroke getStroke(int index) {
        if (index < 0 || index > getSize()){
            return null;
        }
        return stroke.get(index);
    }
    
    public void addStroke(Stroke s) {
        stroke.add(s);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < stroke.size(); i++) {
            sb.append("{");
            sb.append(stroke.get(i).toString());
            sb.append("}");
            if (i + 1 < stroke.size()) {
                sb.append(",");
            }
        }
        return sb.toString();
    }
}
