/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ogakisoft.tomoe;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.xml.sax.InputSource;

/**
 * Convert tomoe-data to gesture-data
 * @author noritoshi ogaki
 */
public class Main {

	private static String converted_file = "/Users/ogakinoritoshi/Documents/temp/tomoe_gestures";
	private static String converted_index_file = "/Users/ogakinoritoshi/Documents/temp/svm_index";
	private static String converted_data_file = "/Users/ogakinoritoshi/Documents/temp/svm_data";
	private Header header;
	private Map<Integer, Long> mId = new HashMap<Integer, Long>();
	private static final int MAX_NUM_OF_INDEX = 100000;
	private static final int MAX_NUM_OF_GESTURES = 10000;
	private static long last_gestureId;
	private static int entry_count;
	
	public void toGesture(GestureHolder h) {
		entry_count = Math.min(MAX_NUM_OF_GESTURES, h.getEntryListSize());
		header = new Header();
		header.fileFormatVersionNumber = 1;
		header.numberOfEntries = entry_count;
		header.entries = new ArrayList<Entry>();
		for (int i = 0; i < entry_count; i++) { //h.getEntryListSize(); i++) {
			Entry entry = new Entry();
			String name = h.getNameAt(i);
			System.out.println(name);
			entry.entryName = name;
			entry.numberOfGestures = h.getStrokesListSize(i);
			entry.gestures = new ArrayList<Gesture>();
			for (int j = 0; j < h.getStrokesListSize(i); j++) {
				Gesture gesture = new Gesture();
				// gesture.gestureId = count++;
				gesture.numberOfStrokes = h.getStrokeListSize(i, j);
				gesture.strokes = new ArrayList<Stroke>();
				for (int k = 0; k < h.getStrokeListSize(i, j); k++) {
					Stroke stroke = new Stroke();
					stroke.numberOfPoints = h.getPointListSize(i, j, k);
					stroke.points = new ArrayList<Point>();
					for (int l = 0; l < h.getPointListSize(i, j, k); l++) {
						Point point = new Point();
						if (h.getPointAt(i, j, k, l) == null) {
//							System.err.println("*NULL*getPointAt:" + "i,j,k,l="
//									+ i + "," + j + "," + k + "," + l);
						} else {
							point.x = (float) h.getPointAt(i, j, k, l).getX();
							// point.x *= 0.3;
							point.y = (float) h.getPointAt(i, j, k, l).getY();
							// point.y *= 0.3;
						}
						point.timeStamp = 0;
						stroke.points.add(point);
					}
					gesture.strokes.add(stroke);
				}
				entry.gestures.add(gesture);
			}
			header.entries.add(entry);
		}
		FileOutputStream fo = null;
		try {
			fo = new FileOutputStream(converted_file);
			save(fo, header);
		} catch (Exception ex) {
			// Logger.getLogger(Converter.class.getName()).log(Level.SEVERE,
			// null, ex);
			ex.printStackTrace();
		}
	}

	public static void main(String[] args) {
		DictHandlerImpl handler = new DictHandlerImpl();
		try {
			DictParser parser = new DictParser(handler, null);
			InputSource source = new InputSource(
					new FileInputStream(
							"/Users/ogakinoritoshi/Documents/workspace/TomoeConvert/xml/handwriting-ja.xml"));
			parser.parse(source);
		} catch (Exception ex) {
			Logger.getLogger(DictParser.class.getName()).log(Level.SEVERE,
					null, ex);
		}
		// convert to gesture format
		Main main = new Main();
		main.toGesture(handler.getHolder());

		try {
			main.saveForSvm(new File(converted_index_file), new File(
					converted_data_file));
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	// private void load(InputStream stream) throws IOException {
	// DataInputStream in = null;
	// try {
	// in = new DataInputStream(
	// (stream instanceof BufferedInputStream) ? stream
	// : new BufferedInputStream(stream, 32 * 1024)); //
	// GestureConstants.IO_BUFFER_SIZE));
	// final short versionNumber = in.readShort();
	// switch (versionNumber) {
	// case 1:
	// readFormatV1(in);
	// break;
	// }
	// } finally {
	// try {
	// stream.close();
	// } catch (IOException e) {
	// e.printStackTrace();
	// }
	// }
	// }
	//
	// private void readFormatV1(DataInputStream in) throws IOException {
	// final int entriesCount = in.readInt();
	// System.out.println("Number of entries:" + entriesCount);
	// for (int i = 0; i < entriesCount; i++) {
	// final String name = in.readUTF();
	// System.out.println("Entry name:" + name);
	// final int gestureCount = in.readInt();
	// System.out.println("Number of gestures:" + gestureCount);
	// for (int j = 0; j < gestureCount; j++) {
	// gestureDeserialize(in);
	// }
	// }
	// }
	//
	// static void gestureDeserialize(DataInputStream in) throws IOException {
	// long mGestureID = in.readLong();
	// System.out.println("gesture id:" + mGestureID);
	// final int count = in.readInt();
	// System.out.println("Number of strokes:" + count);
	// for (int i = 0; i < count; i++) {
	// gestureStrokeDeserialize(in);
	// }
	// }
	//
	// static void gestureStrokeDeserialize(DataInputStream in) throws
	// IOException {
	// final int count = in.readInt();
	// System.out.println("Number of points:" + count);
	// for (int i = 0; i < count; i++) {
	// gesturePointDeserialize(in);
	// }
	// }
	//
	// static void gesturePointDeserialize(DataInputStream in) throws
	// IOException {
	// final float x = in.readFloat();
	// final float y = in.readFloat();
	// final long timeStamp = in.readLong();
	// System.out.println("x=" + x + " y=" + y + " timeStamp=" + timeStamp);
	// }

	private void save(OutputStream stream, Header h) throws IOException {
		DataOutputStream out = null;
		try {
			out = new DataOutputStream(
					(stream instanceof BufferedOutputStream) ? stream
							: new BufferedOutputStream(stream, 32 * 1024)); // GestureConstants.IO_BUFFER_SIZE));
			final short versionNumber = 1; // h.fileFormatVersionNumber;
											// //1;//---
			out.writeShort(versionNumber);
			switch (versionNumber) {
			case 1:
				writeFormatV1(out, h);
				break;
			}
		} finally {
			try {
				out.flush();
				out.close();
				stream.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	private void writeFormatV1(DataOutputStream out, Header h)
			throws IOException {
		final int entriesCount = h.numberOfEntries;
		out.writeInt(entriesCount);
		System.out.println("Number of entries:" + entriesCount);
		for (int i = 0; i < entriesCount; i++) {
			final String name = h.entries.get(i).entryName;
			out.writeUTF(name);
			System.out.println("Entry name:" + name);
			final int gestureCount = h.entries.get(i).numberOfGestures;
			out.writeInt(gestureCount);
			System.out.println("Number of gestures:" + gestureCount);
			for (int j = 0; j < gestureCount; j++) {
				gestureSerialize(out, h.entries.get(i).gestures.get(j));
			}
		}
	}

	static void gestureSerialize(DataOutputStream out, Gesture g)
			throws IOException {
		out.writeLong(g.gestureId);
		System.out.println("gesture id:" + g.gestureId);
		final int count = g.numberOfStrokes;
		out.writeInt(count);
//		System.out.println("Number of strokes:" + count);
		for (int i = 0; i < count; i++) {
			gestureStrokeSerialize(out, g.strokes.get(i));
		}
	}

	static void gestureStrokeSerialize(DataOutputStream out, Stroke s)
			throws IOException {
		final int count = s.numberOfPoints;
		out.writeInt(count);
//		System.out.println("Number of points:" + count);
		for (int i = 0; i < count; i++) {
			gesturePointSerialize(out, s.points.get(i));
		}
	}

	static void gesturePointSerialize(DataOutputStream out, Point p)
			throws IOException {
		final float x = p.x;
		out.writeFloat(x);
		final float y = p.y;
		out.writeFloat(y);
		final long timeStamp = p.timeStamp;
		out.writeLong(timeStamp);
//		System.out.println("x=" + x + " y=" + y + " timeStamp=" + timeStamp);
	}

	class Header {

		short fileFormatVersionNumber;
		int numberOfEntries;
		ArrayList<Entry> entries;
	}

	class Entry {

		String entryName;
		int numberOfGestures;
		ArrayList<Gesture> gestures;
	}

	class Gesture {

		long gestureId;
		int numberOfStrokes;
		ArrayList<Stroke> strokes;
		
		public Gesture() {
			gestureId = System.currentTimeMillis();
			while(last_gestureId - gestureId == 0) {
				gestureId = System.currentTimeMillis();
			}
			last_gestureId = gestureId;
		}
	}

	class Stroke {

		int numberOfPoints;
		ArrayList<Point> points;
	}

	class Point {

		float x = 0f;
		float y = 0f;
		long timeStamp = 0;
	}

	public void saveForSvm(File index_file, File data_file) {
		FileOutputStream data = null;
//		DataOutputStream index = null;
		OutputStreamWriter index = null;
		try {
			data = new FileOutputStream(data_file);
//			index = new DataOutputStream(new FileOutputStream(index_file));
			index = new OutputStreamWriter(new FileOutputStream(index_file), Charset.forName("UTF-8"));
			final List<Entry> entries = header.entries;
			final int entries_count = entries.size();
			for (int i = 0; i < entries_count; i++) {
				Entry entry = entries.get(i);
				List<Gesture> gestures = entry.gestures;
				int gestures_count = gestures.size();
				for (int j = 0; j < gestures_count; j++) {
					Gesture gesture = gestures.get(j);
					// gesture.gestureId
					int intId = convertId(gesture.gestureId);
					mId.put(Integer.valueOf(intId),
							Long.valueOf(gesture.gestureId));
					String str = intId + " " + gesture.gestureId + " " + entry.entryName+ "\n";
//					index.writeBytes(str);
//					index.writeUTF(entry.entryName.trim());
//					index.write("\n".getBytes());
					index.write(str, 0, str.length());
					data.write(String.valueOf(intId).getBytes());
					data.write(" ".getBytes());
					List<Stroke> strokes = gesture.strokes;
					int strokes_count = strokes.size();
					int count = 0;
					for (int k = 0; k < strokes_count; k++) {
						Stroke stroke = strokes.get(k);
						List<Point> points = stroke.points;
						int points_count = points.size();
						for (int l = 0; l < points_count; l++) {
							Point point = points.get(l);
							count++;
							data.write((count + ":" + point.x + " ").getBytes());
							count++;
							data.write((count + ":" + point.y + " ").getBytes());
						}
					}
					data.write("\n".getBytes());
				}
			}

		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			try {
				if (null != data) {
					data.close();
				}
				if (null != index) {
					index.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	private int convertId(long id) {
		int intId = -1;
		if (null != mId) {
			intId = containsId(id);
		}
		if (intId == -1) {
			final String str = String.valueOf(id);
			intId = Integer.parseInt(str.substring(str.length() - 5));
			while (mId.containsKey(Integer.valueOf(intId))) {
				intId = randomNumber();
			}
		}
		return intId;
	}

	private int containsId(long id) {
		int intId = -1;
		synchronized (mId) {
			Map.Entry<Integer, Long> entry;
			for (final Iterator<Map.Entry<Integer, Long>> it = mId.entrySet()
					.iterator(); it.hasNext();) {
				entry = it.next();
				if (entry.getValue().longValue() == id) {
					intId = entry.getKey().intValue();
					break;
				}
			}
		}
		return intId;
	}

	private int randomNumber() {
		final Random random = new Random();
		int i = 0;
		do {
			i = random.nextInt();
		} while (i <= 0 || i > MAX_NUM_OF_INDEX);
		return i;
	}
}
