package ogakisoft.tomoe;

import java.util.ArrayList;
import java.util.List;

public class Entry {

    private String name;
    private List<Strokes> strokes;

    public Entry(String name) {
        this.name = name;
        strokes = new ArrayList<Strokes>(0);
    }

    public void addStrokes(Strokes ss) {
        strokes.add(ss);
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
//        strokes.trimToSize();
        return strokes.size();
    }

    public Strokes getStrokes(int index) {
        if (index < 0 || index >= getSize()) {
            return null;
        }
        return strokes.get(index);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(getName());
        for (int i = 0; i < strokes.size(); i++) {
            sb.append("<");
            sb.append(strokes.get(i).toString());
            sb.append(">");
        }
        return sb.toString();
    }
}
