package ogakisoft.tomoe;

import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public interface DictHandler {

    /**
     *
     * A data element event handling method.
     * @param data value or null
     * @param meta attributes
     */
    public void handle_reading(final String data, final AttributeList meta) throws SAXException;

    /**
     *
     * A data element event handling method.
     * @param data value or null
     * @param meta attributes
     */
    public void handle_utf8(final String data, final AttributeList meta) throws SAXException;

    /**
     *
     * A container element start event handling method.
     * @param meta attributes
     */
    public void start_dictionary(final AttributeList meta) throws SAXException;

    /**
     *
     * A container element end event handling method.
     */
    public void end_dictionary() throws SAXException;

    /**
     *
     * A data element event handling method.
     * @param data value or null
     * @param meta attributes
     */
    public void handle_variant(final String data, final AttributeList meta) throws SAXException;

    /**
     *
     * A data element event handling method.
     * @param data value or null
     * @param meta attributes
     */
    public void handle_meta(final String data, final AttributeList meta) throws SAXException;

    /**
     *
     * A container element start event handling method.
     * @param meta attributes
     */
    public void start_meta(final AttributeList meta) throws SAXException;

    /**
     *
     * A container element end event handling method.
     */
    public void end_meta() throws SAXException;

    /**
     *
     * A container element start event handling method.
     * @param meta attributes
     */
    public void start_character(final AttributeList meta) throws SAXException;

    /**
     *
     * A container element end event handling method.
     */
    public void end_character() throws SAXException;

    /**
     *
     * A container element start event handling method.
     * @param meta attributes
     */
    public void start_stroke(final AttributeList meta) throws SAXException;

    /**
     *
     * A container element end event handling method.
     */
    public void end_stroke() throws SAXException;

    /**
     *
     * An empty element event handling method.
     * @param data value or null
     */
    public void handle_point(final AttributeList meta) throws SAXException;

    /**
     *
     * A container element start event handling method.
     * @param meta attributes
     */
    public void start_radicals(final AttributeList meta) throws SAXException;

    /**
     *
     * A container element end event handling method.
     */
    public void end_radicals() throws SAXException;

    /**
     *
     * A container element start event handling method.
     * @param meta attributes
     */
    public void start_readings(final AttributeList meta) throws SAXException;

    /**
     *
     * A container element end event handling method.
     */
    public void end_readings() throws SAXException;

    /**
     *
     * A data element event handling method.
     * @param data value or null
     * @param meta attributes
     */
    public void handle_radical(final String data, final AttributeList meta) throws SAXException;

    /**
     *
     * A container element start event handling method.
     * @param meta attributes
     */
    public void start_strokes(final AttributeList meta) throws SAXException;

    /**
     *
     * A container element end event handling method.
     */
    public void end_strokes() throws SAXException;

    /**
     *
     * A data element event handling method.
     * @param data value or null
     * @param meta attributes
     */
    public void handle_number_of_strokes(final String data, final AttributeList meta) throws SAXException;

}
