/*
 * Copyright (C) 2008-2011 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Copyright (C) 2011 OgakiSoft
 * 
 * Moved a variable definition in the method top by refactoring.
 */

package ogakisoft.android.gesture.reform;


/**
 * An instance represents a sample if the label is available or a query if the
 * label is null.
 * 
 * @author The Android Open Source Project
 * @author noritoshi ogaki
 * @version 1.0
 */
public class Instance {
//	private static final String TAG = "Instance";

	private static final float[] EMPTY_ARRAY = new float[0];
	private static final int SEQUENCE_SAMPLE_SIZE = 16; // 8;
	private static final int PATCH_SAMPLE_SIZE = 16; // 8;
	private static final float[] ORIENTATIONS = { 0, (float) (Math.PI / 4),
			(float) (Math.PI / 2), (float) (Math.PI * 3 / 4), (float) Math.PI,
			-0, (float) (-Math.PI / 4), (float) (-Math.PI / 2),
			(float) (-Math.PI * 3 / 4), (float) -Math.PI };

	// the feature vector
	public final float[] vector;

	// the label can be null
	public final String label;

	// the id of the instance
	public final long id;

	// the gesture geometric feature
//	public Feature feature;

	public Instance(long id, float[] sample, String sampleName){ //, Feature feature) {
		this.id = id;
		vector = sample;
		label = sampleName;
//		this.feature = feature;
	}

	private void normalize() {
		final float[] sample = vector;
		float sum = 0f;
		float magnitude = 0f;

		final int size = sample.length;
		for (int i = 0; i < size; i++) {
			sum += sample[i] * sample[i];
		}
		magnitude = (float) Math.sqrt(sum);
		for (int i = 0; i < size; i++) {
			sample[i] /= magnitude;
		}
	}

	/**
	 * create a learning instance for a single stroke gesture
	 * 
	 * @param gesture
	 * @param label
	 * @return the instance
	 */
	static Instance createInstance(int sequenceType, int orientationType,
			Gesture gesture, String label) {
		float[] pts = null;
		Instance instance = null;

		if (null == gesture || 0 == gesture.getStrokes().size()) {
			return null;
		}
		if (sequenceType == GestureStore.SEQUENCE_SENSITIVE) {
			pts = temporalSampler(orientationType, gesture);
			instance = new Instance(gesture.getId(), pts, label);
//					GestureUtilities.computeFeature(gesture));
			instance.normalize();
		} else {
			pts = spatialSampler(gesture);
			instance = new Instance(gesture.getId(), pts, label);
//					GestureUtilities.computeFeature(gesture));
		}
		return instance;
	}

	private static float[] spatialSampler(Gesture gesture) {
		return GestureUtilities.spatialSampling(gesture, PATCH_SAMPLE_SIZE);
	}

	protected static float[] temporalSampler(int orientationType,
			Gesture gesture) {
		float[] pts = null;
		float[] center = null;
		float orientation = 0f;
		float adjustment = 0f;
		int count = 0;
		float delta = 0f;
		if (null == gesture || 0 == gesture.getStrokes().size()) {
			return EMPTY_ARRAY;
		}
		pts = GestureUtilities.temporalSampling(
				GestureUtilities.getAllStroke(gesture), SEQUENCE_SAMPLE_SIZE);
		if (pts.length < 2) {
			return EMPTY_ARRAY;
		}
		center = GestureUtilities.computeCentroid(pts);
		orientation = (float) Math
				.atan2(pts[1] - center[1], pts[0] - center[0]);
		adjustment = -orientation;
		if (orientationType == GestureStore.ORIENTATION_SENSITIVE) {
			count = ORIENTATIONS.length;
			delta = 0f;
			for (int i = 0; i < count; i++) {
				delta = ORIENTATIONS[i] - orientation;
				if (Math.abs(delta) < Math.abs(adjustment)) {
					adjustment = delta;
				}
			}
		}
		GestureUtilities.translate(pts, -center[0], -center[1]);
		GestureUtilities.rotate(pts, adjustment);
		return pts;
	}

//	public float match(Feature f) {
//		float result = 0f;
//		if (feature.strokes_count == f.strokes_count) {
//			result += 1f;
//		}
//		if (f.sum_straight > 0 && feature.sum_straight > 0) {
//			result += f.sum_straight / feature.sum_straight;
//		}
//		if (f.sum_circle > 0 && feature.sum_circle > 0) {
//			result += f.sum_circle / feature.sum_circle;
//		}
//		if (f.sum_horizontal_right > 0 && feature.sum_horizontal_right > 0) {
//			result += f.sum_horizontal_right / feature.sum_horizontal_right;
//		}
//		if (f.sum_horizontal_left > 0 && feature.sum_horizontal_left > 0) {
//			result += f.sum_horizontal_left / feature.sum_horizontal_left;
//		}
//		if (f.sum_vertical_down > 0 && feature.sum_vertical_down > 0) {
//			result += f.sum_vertical_down / feature.sum_vertical_down;
//		}
//		if (f.sum_vertical_up > 0 && feature.sum_vertical_up > 0) {
//			result += f.sum_vertical_up / feature.sum_vertical_up;
//		}
//		if (f.sum_parallel > 0 && feature.sum_parallel > 0) {
//			result += f.sum_parallel / feature.sum_parallel;
//			LOG.d(TAG, "match: sum_parallel");
//		}
//		if (f.sum_right_down > 0 && feature.sum_right_down > 0) {
//			result += f.sum_right_down / feature.sum_right_down;
//		}
//		result /= 8;
//		LOG.d(TAG, "match: {0,number,#.###}", result);
//		return result;
//	}
}
