/*
 * Copyright (C) 2008-2011 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package ogakisoft.android.ime;

import ogakisoft.android.gestureime.R;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.inputmethodservice.Keyboard;
import android.view.inputmethod.EditorInfo;

/**
 * LatinKeyboard
 * 
 * @author Google Inc.
 * @version 1.0
 */
public class LatinKeyboard extends Keyboard {

	private Key mEnterKey;

	public LatinKeyboard(Context context, int xmlLayoutResId) {
		super(context, xmlLayoutResId);
	}

	public LatinKeyboard(Context context, int layoutTemplateResId,
			CharSequence characters, int columns, int horizontalPadding) {
		super(context, layoutTemplateResId, characters, columns,
				horizontalPadding);
	}

	@Override
	protected Key createKeyFromXml(Resources res, Row parent, int x, int y,
			XmlResourceParser parser) {
		final Key key = new LatinKey(res, parent, x, y, parser);
		if (10 == key.codes[0]) {
			mEnterKey = key;
		}
		return key;
	}

	/**
	 * This looks at the ime options given by the current editor, to set the
	 * appropriate label on the keyboard's enter key (if it has one).
	 */
	void setImeOptions(Resources res, int options) {
		if (null == mEnterKey) {
			return;
		}

		switch (options
				& (EditorInfo.IME_MASK_ACTION | EditorInfo.IME_FLAG_NO_ENTER_ACTION)) {
		case EditorInfo.IME_ACTION_GO:
			mEnterKey.iconPreview = null;
			mEnterKey.icon = null;
			mEnterKey.label = res.getText(R.string.ime_action_go);
			break;
		case EditorInfo.IME_ACTION_NEXT:
			mEnterKey.iconPreview = null;
			mEnterKey.icon = null;
			mEnterKey.label = res.getText(R.string.ime_action_next);
			break;
		case EditorInfo.IME_ACTION_SEARCH:
			// mEnterKey.icon = res.getDrawable(R.drawable.sym_keyboard_search);
			mEnterKey.icon = null;
			mEnterKey.label = null;
			break;
		case EditorInfo.IME_ACTION_SEND:
			mEnterKey.iconPreview = null;
			mEnterKey.icon = null;
			mEnterKey.label = res.getText(R.string.ime_action_send);
			break;
		default:
			// mEnterKey.icon = res.getDrawable(R.drawable.sym_keyboard_return);
			mEnterKey.icon = null;
			mEnterKey.label = null;
			break;
		}
	}

	static class LatinKey extends Keyboard.Key {

		private LatinKey(Resources res, Keyboard.Row parent, int x, int y,
				XmlResourceParser parser) {
			super(res, parent, x, y, parser);
		}

		/**
		 * Overriding this method so that we can reduce the target area for the
		 * key that closes the keyboard.
		 */
		@Override
		public boolean isInside(int x, int y) {
			int yy = y;
			// return super.isInside(x, (codes[0] == KEYCODE_CANCEL) ? y - 10
			// : y);
			if (codes[0] == KEYCODE_CANCEL) {
				yy = y - 10;
			}
			return super.isInside(x, yy);
		}
	}
}
