/*******************************************************************************
Copyright (C) 2008 HIMACS,ltd.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
   See the License for the specific language governing permissions and limitations under the License.

This Software (including binary module, source code, other additional module)(gSoftwareh)
is provided and licensed by HIMACS, Ltd. (gHIMACSh) on an as is basis and free of charge.
HIMACS disclaims any express or implied warranties, including, but not limited to,
the bug-free and defect-free programming, this Softwarefs perfect running under the recommended
environment for its usage, the implied warranties of merchantability and fitness
for a particular purpose with regard to this Software. HIMACS shall not be responsible for 
all liability for any loss, liability, damages (whether direct or indirect,
incidental or consequential, and including loss of data or profits,
or damages caused by business interruption),
personal injury or expense of any nature whatsoever which may be suffered
by the user of this Software as a result of or which may be attributable, directly or indirectly,
to the use of this Software.
*******************************************************************************/

/**
 * Created on 9 sept. 2008
 * Created by Takaki Tsue, Masato Kawahashi
 * Copyright (C) 2008 HIMACS,ltd. 
 * Licensed under the Apache License, Version 2.0
 *
 */

/*
 * Sample multi thread program for memory leak.
 */

#include <stdio.h>
#include <string.h>
#include <pthread.h>

#define NUMBER_OF_THREADS 10

/*
 * sample leak.
 */
void* echoString(void* msg)
{
	while(1) {
		printf("%d:%s\n", pthread_self(), strdup((char*)msg));
		usleep(2 * 1000 * 1000);
	}
}

/*
 * memory leak sample program.
 */
int main(int argc, char *argv[])
{
	int i = 0;

	for(i = 0; i < NUMBER_OF_THREADS; i++) {
		pthread_t newThread;

		pthread_create(&newThread, NULL, echoString, "hello, thread");
	}

	while(1) {
		usleep(2*1000*1000);
	}
	return 0;
}
