/*******************************************************************************
Copyright (C) 2008 HIMACS,ltd.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
   See the License for the specific language governing permissions and limitations under the License.

This Software (including binary module, source code, other additional module)(gSoftwareh)
is provided and licensed by HIMACS, Ltd. (gHIMACSh) on an as is basis and free of charge.
HIMACS disclaims any express or implied warranties, including, but not limited to,
the bug-free and defect-free programming, this Softwarefs perfect running under the recommended
environment for its usage, the implied warranties of merchantability and fitness
for a particular purpose with regard to this Software. HIMACS shall not be responsible for 
all liability for any loss, liability, damages (whether direct or indirect,
incidental or consequential, and including loss of data or profits,
or damages caused by business interruption),
personal injury or expense of any nature whatsoever which may be suffered
by the user of this Software as a result of or which may be attributable, directly or indirectly,
to the use of this Software.
*******************************************************************************/
/**
 * Created on 9 sept. 2008
 * Created by Takaki Tsue, Masato Kawahashi
 * Copyright (C) 2008 HIMACS,ltd. 
 * Licensed under the Apache License, Version 2.0
 *
 */

/*
 * Common functions.
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <unistd.h>
#include <malloc.h>
#include <execinfo.h>
#include "gerons_core.h"
	
extern GERONS_SHM *logArea; //Shared memopry pointer for logging

/*
 * return max number of log entries.
 */
unsigned long getMaxEntries()
{
	char *pMaxLine = getenv("GERONS_MAX_LINES");
	
	long result = pMaxLine ? atol(pMaxLine) : 0 ;

	return result > 0 ? result : MAX_ENTRY;
}

/*
 * return shmget key.
 */
key_t getShmKey()
{
	char *pShmKey = getenv("GERONS_SHM_KEY");
	key_t result = pShmKey ? (key_t)atol(pShmKey) : 0;

	return result > 0 ? result : SHM_KEY;
}

/*
 * initializer.
 * please do ld command with option -init _init_debug
 */
void _init_common()
{

	// create shared memory if any operation failed, giveup
	if (logArea == NULL) {
		int size = sizeof(GERONS_SHM) + sizeof(SHM_LOG) * getMaxEntries();
		int shmid = shmget(getShmKey(), size, IPC_CREAT|0666);
		if (shmid != -1) {
			logArea = (GERONS_SHM*)shmat(shmid, NULL, 0);
			if ((long)logArea!=-1&&logArea->nEntry == 0) {
				logArea->nEntry = getMaxEntries();
			}
		}
	}
}
