/*
 * Decompiled with CFR 0.152.
 */
package com.tsuetools.gerons;

import com.tsuetools.gerons.CSVAnalyzer;
import com.tsuetools.gerons.CSVReader;
import java.io.IOException;
import java.util.HashMap;

public class Main {
    private HashMap leakMap = new HashMap();
    private HashMap bytesMap = new HashMap();
    private HashMap stackMap = new HashMap();
    private HashMap resultMap = new HashMap();
    private static final String DELIM_COMMA = ",";
    private static final String DELIM_LF = String.valueOf(System.getProperty("line.separator")) + "\t";
    private static final String OPE_MALLOC = "1";
    private static final String OPE_FREE = "2";
    private static final String ERR_MALLOC = "in doubt of memory leak";
    private static final String ERR_FREE = "in doubt of invalid free(ex. double free)";

    private void saveLeak(String line) {
        String ope;
        CSVAnalyzer ana = new CSVAnalyzer(line, DELIM_COMMA);
        int count = 0;
        long totalBytes = 0L;
        String key = ana.getCol(1, 2, DELIM_COMMA);
        String stackKey = ana.getCol(15, 24, DELIM_LF);
        if (this.leakMap.containsKey(key)) {
            count = (Integer)this.leakMap.get(key);
        }
        if (this.bytesMap.containsKey(stackKey)) {
            totalBytes = (Long)this.bytesMap.get(stackKey);
        }
        if ((ope = ana.getCol(4, 4, DELIM_COMMA)).equals(OPE_MALLOC)) {
            ++count;
            totalBytes += Long.parseLong(ana.getCol(3, 3, DELIM_COMMA));
        } else if (ope.equals(OPE_FREE)) {
            --count;
        }
        this.leakMap.put(key, new Integer(count));
        this.bytesMap.put(stackKey, new Long(totalBytes));
        this.stackMap.put(key, stackKey);
    }

    private void report() {
        String[] keyarr = this.resultMap.keySet().toArray(new String[0]);
        int i = 0;
        while (i < keyarr.length) {
            System.out.println(this.resultMap.get(keyarr[i]));
            System.out.println("\t" + keyarr[i]);
            System.out.println();
            ++i;
        }
    }

    private void analyze() {
        String[] keyarr = this.leakMap.keySet().toArray(new String[0]);
        int i = 0;
        while (i < keyarr.length) {
            int count = (Integer)this.leakMap.get(keyarr[i]);
            String stackKey = (String)this.stackMap.get(keyarr[i]);
            if (count > 0) {
                this.resultMap.put(stackKey, "in doubt of memory leak ( " + this.bytesMap.get(stackKey) + " bytes )");
            } else if (count < 0) {
                this.resultMap.put(stackKey, ERR_FREE);
            }
            ++i;
        }
    }

    public static void main(String[] args) throws IOException {
        Main main = new Main();
        String line = null;
        CSVReader reader = new CSVReader(System.in);
        while ((line = reader.next()) != null) {
            main.saveLeak(line);
        }
        main.analyze();
        main.report();
    }
}

