/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.log.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

/**
 * java.util.logging ̏o͂ Apache log4j ̃tH[}bgɕϊ邽߂̃tH[}b^NXB
 * 
 * <P>
 * blanco.log.logging.BlancoLogSimpleFormatter NX𗘗pƁAjava.util.logging ̏o͂
 * Apache log4j ̃tH[}bgɕϊ邱Ƃł܂B
 * </P>
 * <P>
 * java.util.logging  java.util.logging.SimpleFormatter
 * NX̃tH[}bǵA܂ʓIȁuVvȁvtH[}bgł͂ȂƊ̂ł͖ł傤BBlancoLogSimpleFormatter
 * NX𗘗pƁAApache log4j ̃VvȃtH[}bg𓾂邱Ƃo܂BApache
 * log4j́ulog4j.appender.XX.layout.ConversionPattern=%d %-5p %c -
 * %m%nvɑo͂ƂȂĂ܂B
 * </P>
 * <P>
 * <FONT color="#ff00ff">p@</FONT>
 * </P>
 * <P>
 * L̂悤Ȏ菇ŗp邱Ƃo܂B
 * </P>
 * <UL>
 * <LI>NXpXɈȉ̃t@Czu܂B<BR>
 * Javas jre\lib\ext fBNgɔzuƂ@܂B
 * <UL>
 * <LI>blancolog-?.?.?.jar: blancoLogjart@C
 * </UL>
 * 
 * 
 * <LI>java.util.logging ̐ݒύX܂B<BR>
 * łPȕύX@́AJavas jre\lib fBNg logging.properties
 * ύX@łBȂAύXOɃIWĩt@CobNAbv邱Ƃ𐄏܂B
 * <UL>
 * <LI>Javas jre\lib fBNg  logging.properties t@ĆAȉ̉ӏύX܂B(<STRONG>̉ӏ͕ύXȂ悤ɂ܂</STRONG>)<BR>
 * &lt;logging.properties&gt;<BR>
 * <TABLE border="1"> <TBODY>
 * <TR>
 * <TD>cȗc<BR>
 * java.util.logging.ConsoleHandler.formatter=blanco.log.logging.BlancoLogSimpleFormatter<BR>
 * cȗc</TD>
 * </TR>
 * </TBODY> </TABLE> ɂAR\[o͂̃tH[}bgύX܂B
 * <LI>java.util.logging ́AȊOɂ̐ݒύX@񋟂Ă܂B
 * </UL>
 * </UL>
 * <p>
 * <FONT color="#ff00ff">java.util.logging.Level  ÕxƂ̑Ήt</FONT>
 * </p>
 * <P>
 * java.util.logging  Apache log4j
 * ɂ郍ÕxƂł͗xقȂ܂B̂߁AL̂悤ȃ}bsOsĂ܂B
 * </P>
 * <BLOCKQUOTE> <TABLE border="1"> <TBODY>
 * <TR>
 * <TD bgcolor="#ffff00"><STRONG>java.util.logging ̃Ox</STRONG></TD>
 * <TD bgcolor="#ffff00"><STRONG>Õx</STRONG></TD>
 * <TD bgcolor="#ffff00"><STRONG>l</STRONG></TD>
 * </TR>
 * <TR>
 * <TD>java.util.logging.Level.FINEST</TD>
 * <TD>TRACE</TD>
 * <TD>uڍ׃x()vB</TD>
 * </TR>
 * <TR>
 * <TD>java.util.logging.Level.FINER</TD>
 * <TD>TRACE</TD>
 * <TD>uڍ׃x()vB</TD>
 * </TR>
 * <TR>
 * <TD>java.util.logging.Level.FINE</TD>
 * <TD>DEBUG</TD>
 * <TD>uڍ׃x()vB</TD>
 * </TR>
 * <TR>
 * <TD>java.util.logging.Level.CONFIG</TD>
 * <TD>CONF (*1)</TD>
 * <TD>uݒvB<BR>
 * (*1)Apache log4j ɂ́ÃOx݂͑܂B</TD>
 * </TR>
 * <TR>
 * <TD>java.util.logging.Level.INFO</TD>
 * <TD>INFO</TD>
 * <TD>uvB</TD>
 * </TR>
 * <TR>
 * <TD>java.util.logging.Level.WARNING</TD>
 * <TD>WARN</TD>
 * <TD>uxvB</TD>
 * </TR>
 * <TR>
 * <TD>java.util.logging.Level.SEVERE</TD>
 * <TD>ERROR<BR>
 * FATAL (*2)</TD>
 * <TD>uvIvB<BR>
 * (*2)bZ[Wfataln܂̂̂ FATAL Ƀ}bv܂B</TD>
 * </TR>
 * </TBODY> </TABLE> </BLOCKQUOTE>
 * 
 * @author IGA Tosiki
 */
public class BlancoLogSimpleFormatter extends Formatter {
    /**
     * ISO 8601 tH[}bg̓tB
     */
    protected final SimpleDateFormat sdFormat = new SimpleDateFormat(
            "yyyy-MM-dd HH:mm:ss,SSS");

    public String format(final LogRecord argLogRecord) {
        final StringBuffer buf = new StringBuffer(1024);

        logRecordMessage2Buffer(argLogRecord, buf);

        if (argLogRecord.getThrown() != null) {
            // OIuWFNg̏óB
            logRecordThrown2Buffer(argLogRecord.getThrown(), buf);
        }

        return buf.toString();
    }

    protected void logRecordMessage2Buffer(final LogRecord argLogRecord,
            final StringBuffer argBuf) {
        argBuf.append(sdFormat.format(new Date(argLogRecord.getMillis())));
        argBuf.append(" ");

        switch (argLogRecord.getLevel().intValue()) {
        case BlancoLogLoggingConstants.FINEST:
        case BlancoLogLoggingConstants.FINER:
            argBuf.append("TRACE");
            break;
        case BlancoLogLoggingConstants.FINE:
            argBuf.append("DEBUG");
            break;
        case BlancoLogLoggingConstants.CONFIG:
            argBuf.append("CONF ");
            break;
        case BlancoLogLoggingConstants.INFO:
            argBuf.append("INFO ");
            break;
        case BlancoLogLoggingConstants.WARNING:
            argBuf.append("WARN ");
            break;
        case BlancoLogLoggingConstants.SEVERE:
            boolean isFatal = false;
            if (argLogRecord.getMessage().length() >= 5) {
                final String head = argLogRecord.getMessage().substring(0, 5);
                if ("fatal".equals(head.toLowerCase())) {
                    // bZ[W fatal ܂ FATAL ŊJnꍇɂ̂ fatal Ƀ}bsOB
                    isFatal = true;
                }
            }
            if (isFatal) {
                argBuf.append("FATAL");
            } else {
                argBuf.append("ERROR");
            }
            break;
        default:
            argBuf.append(Integer.toString(argLogRecord.getLevel().intValue()));
            argBuf.append("  ");
            break;
        }
        argBuf.append(" ");
        argBuf.append(argLogRecord.getLoggerName());
        argBuf.append(" - ");
        argBuf.append(argLogRecord.getMessage());
        argBuf.append("\n");
    }

    protected void logRecordThrown2Buffer(final Throwable argEx,
            final StringBuffer argBuf) {
        final StringWriter writerResult = new StringWriter(1024);
        final PrintWriter writer = new PrintWriter(writerResult);
        argEx.printStackTrace(writer);
        writer.close();

        argBuf.append(writerResult.toString());
        // X^bNg[X̍Ōɂ͉sŏtĂ܂B̂߁AXȂst^͕svłB
    }
}
