#!/usr/bin/ruby

require 'erb'
require 'dbi'
require 'digest/sha1'
require 'yaml'

printf "Content-Type: text/html\n\n"

yml = YAML.load_file('../genkidama_stats/config.yml')

recent_movies = []
ranking_movies = []
your_recent_movies = []
your_ranking_movies = []
num_of_online_users = 0
num_of_online_data = 0
user_online = false
user_port = 50000
user_version = 0
num_of_user_cache = 0
num_of_user_nicovideo_history = 0
num_of_user_dht_history = 0
num_of_user_cache_history = 0
num_of_nicovideo_history = 0
num_of_dht_history = 0
num_of_cache_history = 0
newest_version = yml['newest_version']
version_up_url = yml['version_up_url']

wiki_url = "http://sourceforge.jp/projects/genkidama/wiki"
proj_url = "http://sourceforge.jp/projects/genkidama"
hateb_url = "http://b.hatena.ne.jp/entry"

begin
  dbh = DBI.connect("DBI:Mysql:#{yml['db_name']}:#{yml['db_host']}",
                    yml['db_user'], yml['db_pass'])

	# {{{ GENKIDAMA RECENT show vids
  sth = dbh.execute("SELECT DISTINCT REPLACE(video_id, 'low', '') FROM nico_video_access_log ORDER BY id DESC LIMIT 30")
  sth.fetch do |row|
    recent_movies.push(row[0])
  end
  	# }}}

	# {{{ GENKIDAMA RANKING show vids
  sth = dbh.execute("SELECT REPLACE(video_id, 'low', ''), count(*) FROM nico_video_access_log GROUP BY 1 ORDER BY 2 DESC LIMIT 30")
  sth.fetch do |row|
    ranking_movies.push({:video_id => row[0], :num_plays => row[1]})
  end
  	# }}}
	
	# {{{ GENKIDAMA STATUS count online users
  sth = dbh.execute('SELECT COUNT(*) FROM online_users')
  sth.fetch do |row|
    num_of_online_users = row[0]
  end
  	# }}}
	
	# {{{ GENKIDAMA STATUS count online data
  sth = dbh.execute('SELECT COUNT(*) FROM online_data')
  sth.fetch do |row|
    num_of_online_data = row[0]
  end
  	# }}}



  sth = dbh.execute('SELECT port, version FROM online_users WHERE address = ?',
                    ENV['REMOTE_ADDR'])
  sth.fetch do |row|
    user_online = true
    user_port = row[0]
    user_version = row[1]
  end

  if user_online then
  	# {{{ USER STATUS count has_put_amount
    sth = dbh.execute('SELECT COUNT(*) FROM online_data WHERE `hash` = ?',
                      Digest::SHA1.hexdigest("#{ENV['REMOTE_ADDR']}:#{user_port}"))
    sth.fetch do |row|
      num_of_user_cache = row[0]
    end
	# }}}
	
	# {{{ USER HISTORY count use_nicovideo
    sth = dbh.execute("SELECT COUNT(*) FROM nico_video_access_log WHERE `node_hash` = ? AND access_mode = 'nicovideo'",
                      Digest::SHA1.hexdigest("#{ENV['REMOTE_ADDR']}:#{user_port}"))
    sth.fetch do |row|
      num_of_user_nicovideo_history = row[0]
    end
	# }}}
	
	# {{{ USER HISTORY count use_dht
    sth = dbh.execute("SELECT COUNT(*) FROM nico_video_access_log WHERE `node_hash` = ? AND access_mode = 'dht'",
                      Digest::SHA1.hexdigest("#{ENV['REMOTE_ADDR']}:#{user_port}"))
    sth.fetch do |row|
      num_of_user_dht_history = row[0]
    end
	# }}}

	# {{{ USER HISTORY count use_cache
    sth = dbh.execute("SELECT COUNT(*) FROM nico_video_access_log WHERE `node_hash` = ? AND access_mode = 'local'",
                      Digest::SHA1.hexdigest("#{ENV['REMOTE_ADDR']}:#{user_port}"))
    sth.fetch do |row|
      num_of_user_cache_history = row[0]
    end
	# }}}
	
	# {{{ USER RECENT show vids
    sth = dbh.execute("SELECT DISTINCT REPLACE(video_id, 'low', '') FROM nico_video_access_log WHERE `node_hash` = ? ORDER BY id DESC LIMIT 30",
                      Digest::SHA1.hexdigest("#{ENV['REMOTE_ADDR']}:#{user_port}"))
    sth.fetch do |row|
      your_recent_movies.push(row[0])
    end
	# }}}
	
	# {{{ USER RANKING show vids
    sth = dbh.execute("SELECT REPLACE(video_id, 'low', ''), count(*) FROM nico_video_access_log WHERE `node_hash` = ? GROUP BY 1 ORDER BY 2 DESC LIMIT 30",
                      Digest::SHA1.hexdigest("#{ENV['REMOTE_ADDR']}:#{user_port}"))
    sth.fetch do |row|
      your_ranking_movies.push({:video_id => row[0], :num_plays => row[1]})
    end
	# }}}
  end
 
 	# {{{ GENKIDAMA HISTORY count use_nicovideo
  sth = dbh.execute("SELECT COUNT(*) FROM nico_video_access_log WHERE access_mode = 'nicovideo'")
  sth.fetch do |row|
    num_of_nicovideo_history = row[0]
  end
  	# }}}
	
	# {{{ GENKIDAMA HISTORY count use_dht
  sth = dbh.execute("SELECT COUNT(*) FROM nico_video_access_log WHERE access_mode = 'dht'")
  sth.fetch do |row|
    num_of_dht_history = row[0]
  end
  	# }}}
	
	# {{{ GENKIDAMA HISTORY count use_cache
  sth = dbh.execute("SELECT COUNT(*) FROM nico_video_access_log WHERE access_mode = 'local'")
  sth.fetch do |row|
    num_of_cache_history = row[0]
  end
  	# }}}
	
  ERB.new(File.read('../genkidama_stats/index.erb')).run(binding)
rescue => e
  puts e.to_s
ensure
  dbh.disconnect if dbh
end
# vi:fdm=marker
