/*
 * Copyright (c) 2009, syuu
 * Licensed under the NicoCache License.
 */

package com.dokukino.genkidama;

/**
 * application version definition class.
 * @author syuu
 * @version $Rev: 94 $
 */
public final class VersionInfo {
	public final static String APPLICATION_NAME = "Genkidama";
	public final static short APPLICATION_ID = 0x0666;
	public final static short APPLICATION_MAJOR_VERSION = 3;
	public final static int APPLICATION_MINOR_VERSION = 2;
	
	/**
	 * return application name and version(major + minor).
	 * @since Rev 55
	 * @return "Genkidama x.x.y"
	 */
	public final static String getFullVersion(){
		String name = APPLICATION_NAME;
		double major = Short.valueOf(APPLICATION_MAJOR_VERSION).doubleValue()/10;
		int minor = APPLICATION_MINOR_VERSION;
		StringBuilder sb = new StringBuilder(name);
		sb.append(" ");
		sb.append(Double.toString(major));
		sb.append(".");
		sb.append(minor);
		return sb.toString();
	}
}
