/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.mock.portlet;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletContext;
import org.seasar.framework.mock.portlet.MockPortletSession;
import org.seasar.framework.util.EnumerationAdapter;

public class MockPortletSessionImpl
implements MockPortletSession {
    private PortletContext portletContext;
    private String id;
    private final long creationTime;
    private long lastAccessedTime;
    private int maxInactiveInterval;
    private boolean valid;
    private boolean new_;
    private Map portletAttributes;
    private Map applicationAttributes;

    public MockPortletSessionImpl(PortletContext portletContext) {
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
        this.maxInactiveInterval = -1;
        this.valid = true;
        this.new_ = true;
        this.portletAttributes = new HashMap();
        this.applicationAttributes = new HashMap();
        this.portletContext = portletContext;
        this.id = "id/" + this.hashCode();
    }

    public Object getAttribute(String name) {
        return this.portletAttributes.get(name);
    }

    public Object getAttribute(String name, int scope) {
        if (scope == 1) {
            return this.applicationAttributes.get(name);
        }
        return this.portletAttributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return new EnumerationAdapter(this.portletAttributes.keySet().iterator());
    }

    public Enumeration getAttributeNames(int scope) {
        if (scope == 1) {
            return new EnumerationAdapter(this.applicationAttributes.keySet().iterator());
        }
        return new EnumerationAdapter(this.portletAttributes.keySet().iterator());
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void invalidate() {
        if (!this.valid) {
            return;
        }
        this.portletAttributes.clear();
        this.applicationAttributes.clear();
        this.valid = false;
    }

    public boolean isNew() {
        return this.new_;
    }

    public void removeAttribute(String name) {
        this.portletAttributes.remove(name);
    }

    public void removeAttribute(String name, int scope) {
        if (scope == 1) {
            this.applicationAttributes.remove(name);
        }
        this.portletAttributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        this.portletAttributes.put(name, value);
    }

    public void setAttribute(String name, Object value, int scope) {
        if (scope == 1) {
            this.applicationAttributes.put(name, value);
        }
        this.portletAttributes.put(name, value);
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public void access() {
        this.new_ = false;
        this.lastAccessedTime = System.currentTimeMillis();
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }
}

