/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.external.servlet;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.external.servlet.CookieMap;
import org.seasar.framework.container.external.servlet.HttpSessionMap;
import org.seasar.framework.container.external.servlet.ServletApplicationMap;
import org.seasar.framework.container.external.servlet.ServletInitParameterMap;
import org.seasar.framework.container.external.servlet.ServletRequestHeaderMap;
import org.seasar.framework.container.external.servlet.ServletRequestHeaderValuesMap;
import org.seasar.framework.container.external.servlet.ServletRequestMap;
import org.seasar.framework.container.external.servlet.ServletRequestParameterMap;
import org.seasar.framework.container.external.servlet.ServletRequestParameterValuesMap;

public class HttpServletExternalContext
implements ExternalContext {
    private ThreadLocal requests = new ThreadLocal();
    private ThreadLocal responses = new ThreadLocal();
    private ThreadLocal requestMaps = new MutableMapThreadLocal();
    private ThreadLocal requestHeaderMaps = new ImmutableMapThreadLocal();
    private ThreadLocal requestHeaderValuesMaps = new ImmutableMapThreadLocal();
    private ThreadLocal requestParameterMaps = new ImmutableMapThreadLocal();
    private ThreadLocal requestParameterValuesMaps = new ImmutableMapThreadLocal();
    private ThreadLocal requestCookieMaps = new ImmutableMapThreadLocal();
    private ThreadLocal sessionMaps = new MutableMapThreadLocal();
    private ServletContext application;

    public Object getRequest() {
        return this.getHttpServletRequest();
    }

    protected HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)this.requests.get();
    }

    public void setRequest(Object request) {
        this.requests.set(request);
        if (request == null) {
            this.requestMaps.set(new HashMap());
            this.requestHeaderMaps.set(Collections.EMPTY_MAP);
            this.requestHeaderValuesMaps.set(Collections.EMPTY_MAP);
            this.requestParameterMaps.set(Collections.EMPTY_MAP);
            this.requestParameterValuesMaps.set(Collections.EMPTY_MAP);
            this.requestCookieMaps.set(Collections.EMPTY_MAP);
            this.sessionMaps.set(new HashMap());
        } else {
            HttpServletRequest req = (HttpServletRequest)request;
            this.requestMaps.set(new ServletRequestMap((ServletRequest)req));
            this.requestHeaderMaps.set(new ServletRequestHeaderMap(req));
            this.requestHeaderValuesMaps.set(new ServletRequestHeaderValuesMap(req));
            this.requestParameterMaps.set(new ServletRequestParameterMap((ServletRequest)req));
            this.requestParameterValuesMaps.set(new ServletRequestParameterValuesMap((ServletRequest)req));
            this.requestCookieMaps.set(new CookieMap(req));
            this.sessionMaps.set(null);
        }
    }

    public Object getResponse() {
        return this.responses.get();
    }

    public void setResponse(Object response) {
        this.responses.set(response);
    }

    public Object getSession() {
        return this.getHttpSession();
    }

    protected HttpSession getHttpSession() {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            return null;
        }
        return request.getSession();
    }

    public Object getApplication() {
        return this.application;
    }

    public void setApplication(Object application) {
        if (!(application instanceof ServletContext)) {
            throw new IllegalArgumentException("application:" + application);
        }
        this.application = (ServletContext)application;
    }

    public Map getApplicationMap() {
        return new ServletApplicationMap(this.application);
    }

    public Map getInitParameterMap() {
        return new ServletInitParameterMap(this.application);
    }

    public Map getRequestCookieMap() {
        return (Map)this.requestCookieMaps.get();
    }

    public Map getRequestHeaderMap() {
        return (Map)this.requestHeaderMaps.get();
    }

    public Map getRequestHeaderValuesMap() {
        return (Map)this.requestHeaderValuesMaps.get();
    }

    public Map getRequestMap() {
        return (Map)this.requestMaps.get();
    }

    public Map getRequestParameterMap() {
        return (Map)this.requestParameterMaps.get();
    }

    public Map getRequestParameterValuesMap() {
        return (Map)this.requestParameterValuesMaps.get();
    }

    public Map getSessionMap() {
        Map sessionMap = (Map)this.sessionMaps.get();
        if (sessionMap != null) {
            return sessionMap;
        }
        sessionMap = new HttpSessionMap(this.getHttpServletRequest());
        this.sessionMaps.set(sessionMap);
        return sessionMap;
    }

    private static class ImmutableMapThreadLocal
    extends ThreadLocal {
        private ImmutableMapThreadLocal() {
        }

        protected Object initialValue() {
            return Collections.EMPTY_MAP;
        }
    }

    private static class MutableMapThreadLocal
    extends ThreadLocal {
        private MutableMapThreadLocal() {
        }

        protected Object initialValue() {
            return new HashMap();
        }
    }
}

