/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.beans.converter;

import java.sql.Timestamp;
import java.util.Date;
import org.seasar.framework.beans.Converter;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.StringConversionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.TimestampConversionUtil;

public class TimestampConverter
implements Converter {
    protected String pattern;

    public TimestampConverter(String pattern) {
        if (StringUtil.isEmpty(pattern)) {
            throw new EmptyRuntimeException("pattern");
        }
        this.pattern = pattern;
    }

    public Object getAsObject(String value) {
        if (StringUtil.isEmpty(value)) {
            return null;
        }
        return TimestampConversionUtil.toTimestamp(value, this.pattern);
    }

    public String getAsString(Object value) {
        return StringConversionUtil.toString((Date)value, this.pattern);
    }

    public boolean isTarget(Class clazz) {
        return clazz == Timestamp.class;
    }
}

