/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.version;

import java.io.File;
import java.util.List;
import org.seasar.extension.jdbc.gen.internal.exception.IllegalVersionRuntimeException;
import org.seasar.extension.jdbc.gen.sql.SqlExecutionContext;
import org.seasar.extension.jdbc.gen.sql.SqlUnitExecutor;
import org.seasar.extension.jdbc.gen.version.DdlVersionDirectory;
import org.seasar.extension.jdbc.gen.version.DdlVersionDirectoryTree;
import org.seasar.extension.jdbc.gen.version.Migrater;
import org.seasar.extension.jdbc.gen.version.SchemaInfoTable;
import org.seasar.framework.log.Logger;

public class MigraterImpl
implements Migrater {
    protected static String LATEST_VERSION = "latest";
    protected static String NEXT_VERSION = "next";
    protected static String PREVIOUS_VERSION = "previous";
    protected static Logger logger = Logger.getLogger(MigraterImpl.class);
    protected SqlUnitExecutor sqlUnitExecutor;
    protected SchemaInfoTable schemaInfoTable;
    protected DdlVersionDirectoryTree ddlVersionDirectoryTree;
    protected String env;
    protected String version;

    public MigraterImpl(SqlUnitExecutor sqlUnitExecutor, SchemaInfoTable schemaInfoTable, DdlVersionDirectoryTree ddlVersionDirectoryTree, String version, String env) {
        if (sqlUnitExecutor == null) {
            throw new NullPointerException("sqlUnitExecutor");
        }
        if (schemaInfoTable == null) {
            throw new NullPointerException("schemaInfoTable");
        }
        if (ddlVersionDirectoryTree == null) {
            throw new NullPointerException("ddlVersionDirectoryTree");
        }
        if (version == null) {
            throw new NullPointerException("version");
        }
        if (env == null) {
            throw new NullPointerException("env");
        }
        this.sqlUnitExecutor = sqlUnitExecutor;
        this.schemaInfoTable = schemaInfoTable;
        this.ddlVersionDirectoryTree = ddlVersionDirectoryTree;
        this.version = version;
        this.env = env;
    }

    public void migrate(Migrater.Callback callback) {
        int from = this.schemaInfoTable.getVersionNo();
        int to = this.getDestVersion(from);
        logger.log("IS2JDBCGen0005", new Object[]{from, to});
        this.migrateInternal(callback, from, to);
        logger.log("IS2JDBCGen0006", new Object[]{from, to});
    }

    protected int getDestVersion(int from) {
        int latest = this.ddlVersionDirectoryTree.getDdlInfoFile().getCurrentVersionNo();
        if (LATEST_VERSION.equalsIgnoreCase(this.version)) {
            return latest;
        }
        if (NEXT_VERSION.equalsIgnoreCase(this.version)) {
            long next = from + 1;
            if (next > (long)latest) {
                return latest;
            }
            this.checkVersionRange(next);
            return (int)next;
        }
        if (PREVIOUS_VERSION.equalsIgnoreCase(this.version)) {
            long previous = from - 1;
            if (previous < 0L) {
                return 0;
            }
            this.checkVersionRange(previous);
            return (int)previous;
        }
        return this.convertToInt(this.version);
    }

    protected int convertToInt(String value) {
        int versionNo;
        try {
            versionNo = Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalVersionRuntimeException(this.version, value);
        }
        if (versionNo < 0) {
            throw new IllegalVersionRuntimeException(this.version, value);
        }
        return versionNo;
    }

    protected void checkVersionRange(long value) {
        if (value < 0L || Integer.MAX_VALUE < value) {
            new IllegalVersionRuntimeException(this.version, value);
        }
    }

    protected void migrateInternal(final Migrater.Callback callback, int from, final int to) {
        DdlVersionDirectory fromVersionDir = this.ddlVersionDirectoryTree.getVersionDirectory(from);
        final List<File> dropFileList = fromVersionDir.getDropDirectory().listAllFiles();
        DdlVersionDirectory toVersionDir = this.ddlVersionDirectoryTree.getVersionDirectory(to);
        final List<File> createFileList = toVersionDir.getCreateDirectory().listAllFiles();
        this.sqlUnitExecutor.execute(new SqlUnitExecutor.Callback(){

            public void execute(SqlExecutionContext context) {
                for (File file : dropFileList) {
                    callback.drop(context, file);
                }
                MigraterImpl.this.schemaInfoTable.setVersionNo(to);
                for (File file : createFileList) {
                    callback.create(context, file);
                }
            }
        });
    }
}

