/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.version;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seasar.extension.jdbc.gen.internal.util.DefaultExcludesFilenameFilter;
import org.seasar.extension.jdbc.gen.internal.util.FileComparetor;
import org.seasar.extension.jdbc.gen.internal.util.FileUtil;
import org.seasar.extension.jdbc.gen.version.ManagedFile;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedFileImpl
implements ManagedFile {
    protected ManagedFile parent;
    protected FileInfo fileInfo;
    protected FileInfo envNamedFileInfo;

    protected ManagedFileImpl(String basePath, String relativePath, String env) {
        this(null, basePath, relativePath, env);
    }

    protected ManagedFileImpl(ManagedFile parent, String basePath, String relativePath, String env) {
        if (basePath == null) {
            throw new NullPointerException("basePath");
        }
        if (relativePath == null) {
            throw new NullPointerException("relativePath");
        }
        this.parent = parent;
        this.fileInfo = new FileInfo(basePath, basePath, relativePath, env);
        if (env != null) {
            this.envNamedFileInfo = new FileInfo(basePath + "#" + env, basePath, relativePath, env);
        }
    }

    @Override
    public File asFile() {
        return this.getFile();
    }

    @Override
    public String getRelativePath() {
        return this.getFileInfo().relativePath;
    }

    @Override
    public String getName() {
        return this.getFile().getName();
    }

    @Override
    public boolean delete() {
        return this.getFile().delete();
    }

    @Override
    public boolean exists() {
        return this.getFile().exists();
    }

    @Override
    public boolean isDirectory() {
        return this.getFile().isDirectory();
    }

    @Override
    public ManagedFile getParent() {
        return this.parent;
    }

    @Override
    public boolean mkdir() {
        return this.getFile().mkdir();
    }

    @Override
    public boolean mkdirs() {
        return this.getFile().mkdirs();
    }

    @Override
    public boolean createNewFile() {
        return FileUtil.createNewFile(this.getFile());
    }

    @Override
    public List<ManagedFile> listManagedFiles() {
        File[] files = this.getFile().listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<ManagedFile> list = new ArrayList<ManagedFile>(files.length);
        for (File file : files) {
            list.add(this.createChildInternal(file.getName()));
        }
        return list;
    }

    @Override
    public List<ManagedFile> listManagedFiles(FilenameFilter filter) {
        File[] files = this.getFile().listFiles(filter);
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<ManagedFile> list = new ArrayList<ManagedFile>(files.length);
        for (File file : files) {
            list.add(this.createChildInternal(file.getName()));
        }
        return list;
    }

    @Override
    public ManagedFile createChild(String childName) {
        return this.createChildInternal(childName);
    }

    protected ManagedFile createChildInternal(String relativePath) {
        FileInfo info = this.getFileInfo();
        ManagedFileImpl file = new ManagedFileImpl(this, info.logicalBasePath, info.relativePath + File.separator + relativePath, info.env);
        return file;
    }

    @Override
    public List<File> listAllFiles() {
        LinkedHashMap<String, File> fileMap = new LinkedHashMap<String, File>();
        if (this.envNamedFileInfo != null) {
            this.traverseDirectory(this.envNamedFileInfo, fileMap);
        }
        this.traverseDirectory(this.fileInfo, fileMap);
        File[] files = fileMap.values().toArray(new File[fileMap.size()]);
        return Arrays.asList(files);
    }

    protected void traverseDirectory(final FileInfo fileInfo, final Map<String, File> fileMap) {
        FileUtil.traverseDirectory(fileInfo.file, new DefaultExcludesFilenameFilter(), new FileComparetor(), new FileUtil.FileHandler(){

            public void handle(File file) {
                String canonicalPath = FileUtil.getCanonicalPath(file);
                String path = StringUtil.trimPrefix((String)canonicalPath, (String)(fileInfo.actualBasePath + File.separator));
                if (!fileMap.containsKey(path)) {
                    fileMap.put(path, file);
                }
            }
        });
    }

    @Override
    public boolean hasChild() {
        String[] paths = this.getFile().list();
        return paths != null && paths.length > 0;
    }

    protected File getFile() {
        return this.getFileInfo().file;
    }

    protected FileInfo getFileInfo() {
        return this.envNamedFileInfo != null ? this.envNamedFileInfo : this.fileInfo;
    }

    protected static class FileInfo {
        protected String actualBasePath;
        protected String logicalBasePath;
        protected String relativePath;
        protected String env;
        protected File file;

        public FileInfo(String actualBasePath, String logicalBasePath, String relativePath, String env) {
            this.actualBasePath = actualBasePath;
            this.logicalBasePath = logicalBasePath;
            this.relativePath = relativePath;
            this.env = env;
            File f = new File(actualBasePath, relativePath);
            this.file = FileUtil.getCanonicalFile(f);
        }
    }
}

