/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.version;

import java.io.File;
import org.seasar.extension.jdbc.gen.internal.util.FileUtil;
import org.seasar.extension.jdbc.gen.internal.version.ManagedFileImpl;
import org.seasar.extension.jdbc.gen.version.DdlVersionDirectory;
import org.seasar.extension.jdbc.gen.version.ManagedFile;
import org.seasar.framework.util.StringConversionUtil;

public class DdlVersionDirectoryImpl
extends ManagedFileImpl
implements DdlVersionDirectory {
    protected static String CREATE_DIR_NAME = "create";
    protected static String DROP_DIR_NAME = "drop";
    protected int versionNo;

    public DdlVersionDirectoryImpl(File baseDir, int versionNo, String versionNoPattern, String env) {
        super(DdlVersionDirectoryImpl.getVersionDirPath(baseDir, versionNo, versionNoPattern), ".", env);
        this.versionNo = versionNo;
    }

    protected static String getVersionDirPath(File baseDir, int versionNo, String versionNoPattern) {
        String versionName = StringConversionUtil.toString((Number)versionNo, (String)versionNoPattern);
        File versionDir = new File(baseDir, versionName);
        return FileUtil.getCanonicalPath(versionDir);
    }

    public ManagedFile getCreateDirectory() {
        return this.createChildInternal(CREATE_DIR_NAME);
    }

    public ManagedFile getDropDirectory() {
        return this.createChildInternal(DROP_DIR_NAME);
    }

    public int getVersionNo() {
        return this.versionNo;
    }

    public boolean isFirstVersion() {
        return this.versionNo == 0;
    }
}

