/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.util;

import java.util.regex.Pattern;
import org.seasar.extension.jdbc.gen.internal.exception.IllegalDumpValueRuntimeException;

public class DumpUtil {
    protected static String QUOTE = "\"";
    protected static String ESCAPED_QUOTE = "\"\"";
    protected static Pattern DECODE_TARGET_PATTERN = Pattern.compile("^\".*\"$", 32);

    protected DumpUtil() {
    }

    public static String encode(String value) {
        if (value == null) {
            return "";
        }
        String s = value.replace(QUOTE, ESCAPED_QUOTE);
        return DumpUtil.quote(s);
    }

    public static String decode(String value) {
        if (value == null || value.equals("")) {
            return null;
        }
        if (DECODE_TARGET_PATTERN.matcher(value).matches()) {
            String s = value.substring(1, value.length() - 1);
            return s.replace(ESCAPED_QUOTE, QUOTE);
        }
        for (char c : value.toCharArray()) {
            if (c != '\"' && c != ',' && c != '\n' && c != '\r') continue;
            throw new IllegalDumpValueRuntimeException(value);
        }
        return value;
    }

    public static String quote(String value) {
        return QUOTE + value + QUOTE;
    }
}

