/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.sqltype;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.gen.internal.sqltype.AbstractSqlType;
import org.seasar.framework.util.BigDecimalConversionUtil;
import org.seasar.framework.util.StringConversionUtil;

public class DecimalType
extends AbstractSqlType {
    public DecimalType() {
        this("decimal");
    }

    public DecimalType(String dataType) {
        super(dataType);
    }

    public void bindValue(PreparedStatement ps, int index, String value) throws SQLException {
        if (value == null) {
            ps.setNull(index, 3);
        } else {
            ps.setBigDecimal(index, BigDecimalConversionUtil.toBigDecimal((Object)value));
        }
    }

    public String getValue(ResultSet resultSet, int index) throws SQLException {
        BigDecimal value = resultSet.getBigDecimal(index);
        return value != null ? StringConversionUtil.toString((Object)value) : null;
    }
}

