/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.sqltype;

import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.gen.internal.sqltype.AbstractSqlType;
import org.seasar.framework.util.BigDecimalConversionUtil;
import org.seasar.framework.util.BigIntegerConversionUtil;
import org.seasar.framework.util.StringConversionUtil;

public class BigIntType
extends AbstractSqlType {
    public BigIntType() {
        this("bigint");
    }

    public BigIntType(String dataType) {
        super(dataType);
    }

    public void bindValue(PreparedStatement ps, int index, String value) throws SQLException {
        if (value == null) {
            ps.setNull(index, -5);
        } else {
            ps.setBigDecimal(index, BigDecimalConversionUtil.toBigDecimal((Object)value));
        }
    }

    public String getValue(ResultSet resultSet, int index) throws SQLException {
        BigInteger value = BigIntegerConversionUtil.toBigInteger((Object)resultSet.getBigDecimal(index));
        return StringConversionUtil.toString((Object)value);
    }
}

