/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.data;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.seasar.extension.jdbc.gen.desc.ColumnDesc;
import org.seasar.extension.jdbc.gen.desc.TableDesc;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.util.CloseableUtil;
import org.seasar.extension.jdbc.gen.internal.util.DumpUtil;
import org.seasar.extension.jdbc.gen.sqltype.SqlType;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.CaseInsensitiveMap;
import org.seasar.framework.util.FileOutputStreamUtil;

public class DumpFileWriter {
    protected static Logger logger = Logger.getLogger(DumpFileWriter.class);
    protected File dumpFile;
    protected GenDialect dialect;
    protected TableDesc tableDesc;
    protected String encoding;
    protected Map<String, ColumnDesc> columnDescMap = new CaseInsensitiveMap();
    protected char delimiter;
    protected BufferedWriter writer;
    protected int lineNumber;

    public DumpFileWriter(File dumpFile, TableDesc tableDesc, GenDialect dialect, String encoding, char delimiter) {
        if (dumpFile == null) {
            throw new NullPointerException("dumpFile");
        }
        if (tableDesc == null) {
            throw new NullPointerException("tableDesc");
        }
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        if (encoding == null) {
            throw new NullPointerException("encoding");
        }
        this.dumpFile = dumpFile;
        this.dialect = dialect;
        this.tableDesc = tableDesc;
        this.encoding = encoding;
        this.delimiter = delimiter;
        this.setupColumnDescMap();
    }

    protected void setupColumnDescMap() {
        for (ColumnDesc columnDesc : this.tableDesc.getColumnDescList()) {
            if (this.isIgnoreColumn(columnDesc)) continue;
            this.columnDescMap.put(columnDesc.getName(), columnDesc);
        }
    }

    public void writeHeaderOnly() {
        int size = this.tableDesc.getColumnDescList().size();
        StringBuilder buf = new StringBuilder(size * 10);
        for (ColumnDesc columnDesc : this.tableDesc.getColumnDescList()) {
            if (this.isIgnoreColumn(columnDesc)) continue;
            String columnName = columnDesc.getName();
            buf.append(DumpUtil.quote(columnName));
            buf.append(this.delimiter);
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        this.writeLine(buf.toString());
    }

    protected boolean isIgnoreColumn(ColumnDesc columnDesc) {
        return columnDesc.isIdentity() && !this.dialect.supportsIdentityInsert();
    }

    public void writeRows(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        Header header = this.createHeader(metaData);
        this.writeHeader(header);
        while (rs.next()) {
            this.writeRowData(rs, header);
        }
    }

    protected void writeHeader(Header header) {
        StringBuilder buf = new StringBuilder(header.columnList.size() * 10);
        for (HeaderColumn headerColumn : header.columnList) {
            String columnName = headerColumn.columnDesc.getName();
            buf.append(DumpUtil.quote(columnName));
            buf.append(this.delimiter);
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        this.writeLine(buf.toString());
    }

    protected void writeRowData(ResultSet resultSet, Header header) throws SQLException {
        StringBuilder buf = new StringBuilder(header.columnList.size() * 10);
        for (HeaderColumn headerColumn : header.columnList) {
            String value = null;
            if (headerColumn.present) {
                SqlType sqlType = headerColumn.columnDesc.getSqlType();
                value = sqlType.getValue(resultSet, headerColumn.index);
            }
            buf.append(DumpUtil.encode(value));
            buf.append(this.delimiter);
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        this.writeLine(buf.toString());
    }

    protected void writeLine(String line) {
        if (this.writer == null) {
            this.writer = this.createBufferdWriter();
        }
        try {
            this.writer.write(line);
            this.writer.newLine();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        ++this.lineNumber;
    }

    protected BufferedWriter createBufferdWriter() {
        this.dumpFile.getParentFile().mkdirs();
        Charset charset = Charset.forName(this.encoding);
        FileOutputStream fos = FileOutputStreamUtil.create((File)this.dumpFile);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, charset);
        return new BufferedWriter(osw);
    }

    public void close() {
        CloseableUtil.close(this.writer);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    protected Header createHeader(ResultSetMetaData metaData) throws SQLException {
        String columnLabel;
        Header header = new Header();
        CaseInsensitiveMap indexMap = new CaseInsensitiveMap();
        for (int i = 0; i < metaData.getColumnCount(); ++i) {
            int index = i + 1;
            columnLabel = metaData.getColumnLabel(index);
            indexMap.put(columnLabel, index);
        }
        for (Map.Entry<String, ColumnDesc> entry : this.columnDescMap.entrySet()) {
            columnLabel = entry.getKey();
            if (indexMap.containsKey(columnLabel)) {
                int index = (Integer)indexMap.get(columnLabel);
                HeaderColumn headerColumn = new HeaderColumn();
                headerColumn.columnDesc = entry.getValue();
                headerColumn.index = index;
                headerColumn.present = true;
                header.columnList.add(headerColumn);
                continue;
            }
            HeaderColumn headerColumn = new HeaderColumn();
            headerColumn.columnDesc = entry.getValue();
            header.columnList.add(headerColumn);
        }
        return header;
    }

    protected static class HeaderColumn {
        protected ColumnDesc columnDesc;
        protected boolean present;
        protected int index;

        protected HeaderColumn() {
        }
    }

    protected static class Header {
        protected List<HeaderColumn> columnList = new ArrayList<HeaderColumn>();

        protected Header() {
        }
    }
}

