/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.data;

public class DumpFileTokenizer {
    protected StringBuilder buf = new StringBuilder(200);
    protected int pos;
    protected int nextPos;
    protected int length;
    protected char delimiter;
    protected TokenType type = TokenType.END_OF_LINE;
    protected String token;
    protected boolean endOfFile;

    public DumpFileTokenizer(char delimiter) {
        this.delimiter = delimiter;
    }

    public void addChars(char[] chars, int len) {
        if (this.endOfFile) {
            throw new IllegalStateException("endOfFile");
        }
        if (len < 0) {
            this.endOfFile = true;
        } else {
            this.buf.append(chars, 0, len);
        }
        this.length = this.buf.length();
        this.peek(this.pos);
    }

    protected void peek(int index) {
        if (index < this.length) {
            this.pos = index;
            char c = this.buf.charAt(index);
            if (c == '\"') {
                for (int i = index + 1; i < this.length; ++i) {
                    c = this.buf.charAt(i);
                    if (c != '\"' || ++i >= this.length || (c = this.buf.charAt(i)) == '\"') continue;
                    for (int j = i; j < this.length; ++j) {
                        c = this.buf.charAt(j);
                        if (c != this.delimiter && !this.isEndOfLine(j)) continue;
                        this.type = TokenType.VALUE;
                        this.nextPos = j;
                        return;
                    }
                }
                this.type = this.endOfFile ? TokenType.END_OF_FILE : TokenType.END_OF_BUFFER;
            } else if (c == this.delimiter) {
                if (this.type == TokenType.END_OF_LINE || this.type == TokenType.DELIMITER) {
                    this.type = TokenType.NULL;
                    this.nextPos = index;
                } else {
                    this.type = TokenType.DELIMITER;
                    this.nextPos = index + 1;
                }
            } else if (this.isEndOfLine(index)) {
                if (this.type == TokenType.END_OF_LINE || this.type == TokenType.DELIMITER) {
                    this.type = TokenType.NULL;
                    this.nextPos = index;
                } else {
                    this.type = TokenType.END_OF_LINE;
                    this.nextPos = this.isCRLF(index) ? index + 2 : index + 1;
                }
            } else if (c == '\r') {
                if (this.type == TokenType.END_OF_LINE || this.type == TokenType.DELIMITER) {
                    this.type = TokenType.NULL;
                    this.nextPos = index;
                } else {
                    this.type = this.endOfFile ? TokenType.END_OF_FILE : TokenType.END_OF_BUFFER;
                }
            } else {
                for (int i = index; i < this.length; ++i) {
                    c = this.buf.charAt(i);
                    if (c != this.delimiter && !this.isEndOfLine(i)) continue;
                    this.type = TokenType.VALUE;
                    this.nextPos = i;
                    return;
                }
                this.type = this.endOfFile ? TokenType.END_OF_FILE : TokenType.END_OF_BUFFER;
            }
        } else {
            this.type = this.endOfFile ? TokenType.END_OF_FILE : TokenType.END_OF_BUFFER;
        }
    }

    protected boolean isEndOfLine(int index) {
        char c = this.buf.charAt(index);
        return c == '\r' ? index + 1 < this.length || this.endOfFile : c == '\n';
    }

    protected boolean isCRLF(int index) {
        char c = this.buf.charAt(index);
        if (c == '\r') {
            int i = index + 1;
            return i < this.length && this.buf.charAt(i) == '\n';
        }
        return false;
    }

    public TokenType nextToken() {
        switch (this.type) {
            case VALUE: {
                this.token = this.buf.substring(this.pos, this.nextPos);
                this.peek(this.nextPos);
                return TokenType.VALUE;
            }
            case NULL: {
                this.token = this.buf.substring(this.pos, this.nextPos);
                this.peek(this.nextPos);
                return TokenType.NULL;
            }
            case DELIMITER: {
                this.token = this.buf.substring(this.pos, this.nextPos);
                this.peek(this.nextPos);
                return TokenType.DELIMITER;
            }
            case END_OF_LINE: {
                this.token = this.buf.substring(this.pos, this.nextPos);
                this.buf.delete(0, this.nextPos);
                this.buf.trimToSize();
                this.length = this.buf.length();
                this.pos = 0;
                this.nextPos = 0;
                this.peek(0);
                return TokenType.END_OF_LINE;
            }
            case END_OF_BUFFER: {
                this.token = this.buf.substring(this.pos);
                return TokenType.END_OF_BUFFER;
            }
            case END_OF_FILE: {
                this.token = this.buf.substring(this.pos);
                return TokenType.END_OF_FILE;
            }
        }
        throw new IllegalStateException(this.type.name());
    }

    public String getToken() {
        return this.token;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TokenType {
        VALUE,
        NULL,
        DELIMITER,
        END_OF_LINE,
        END_OF_BUFFER,
        END_OF_FILE;

    }
}

