/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.command;

import java.io.File;
import javax.persistence.GenerationType;
import org.seasar.extension.jdbc.gen.desc.EntityDesc;
import org.seasar.extension.jdbc.gen.desc.EntitySetDesc;
import org.seasar.extension.jdbc.gen.desc.EntitySetDescFactory;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.generator.GenerationContext;
import org.seasar.extension.jdbc.gen.generator.Generator;
import org.seasar.extension.jdbc.gen.internal.command.AbstractCommand;
import org.seasar.extension.jdbc.gen.internal.util.FileUtil;
import org.seasar.extension.jdbc.gen.meta.DbTableMetaReader;
import org.seasar.extension.jdbc.gen.model.ClassModel;
import org.seasar.extension.jdbc.gen.model.EntityModel;
import org.seasar.extension.jdbc.gen.model.EntityModelFactory;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ClassUtil;

public class GenerateEntityCommand
extends AbstractCommand {
    protected static Logger logger = Logger.getLogger(GenerateEntityCommand.class);
    protected String schemaName = null;
    protected String tableNamePattern = ".*";
    protected String ignoreTableNamePattern = "(SCHEMA_INFO|.*\\$.*)";
    protected String versionColumnNamePattern = "VERSION([_]?NO)?";
    protected File pluralFormFile = null;
    protected boolean useTemporalType = false;
    protected boolean useAccessor = false;
    protected GenerationType generationType = null;
    protected Integer initialValue = null;
    protected Integer allocationSize = null;
    protected boolean showCatalogName = false;
    protected boolean showSchemaName = false;
    protected boolean showTableName = false;
    protected boolean showColumnName = false;
    protected boolean showColumnDefinition = false;
    protected boolean showJoinColumn = false;
    protected String entityTemplateFileName = "java/entity.ftl";
    protected String templateFileEncoding = "UTF-8";
    protected File templateFilePrimaryDir = null;
    protected String rootPackageName = "";
    protected String entityPackageName = "entity";
    protected String entitySuperclassName = null;
    protected File javaFileDestDir = new File(new File("src", "main"), "java");
    protected String javaFileEncoding = "UTF-8";
    protected boolean overwrite = false;
    protected boolean applyDbCommentToJava = false;
    protected String genDialectClassName = null;
    protected GenDialect dialect;
    protected DbTableMetaReader dbTableMetaReader;
    protected EntitySetDescFactory entitySetDescFactory;
    protected Generator generator;
    protected EntityModelFactory entityModelFactory;

    public String getEntityPackageName() {
        return this.entityPackageName;
    }

    public void setEntityPackageName(String entityPackageName) {
        this.entityPackageName = entityPackageName;
    }

    public String getEntityTemplateFileName() {
        return this.entityTemplateFileName;
    }

    public void setEntityTemplateFileName(String entityTemplateFileName) {
        this.entityTemplateFileName = entityTemplateFileName;
    }

    public File getJavaFileDestDir() {
        return this.javaFileDestDir;
    }

    public void setJavaFileDestDir(File javaFileDestDir) {
        this.javaFileDestDir = javaFileDestDir;
    }

    public String getJavaFileEncoding() {
        return this.javaFileEncoding;
    }

    public void setJavaFileEncoding(String javaFileEncoding) {
        this.javaFileEncoding = javaFileEncoding;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String getRootPackageName() {
        return this.rootPackageName;
    }

    public void setRootPackageName(String rootPackageName) {
        this.rootPackageName = rootPackageName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTemplateFileEncoding() {
        return this.templateFileEncoding;
    }

    public void setTemplateFileEncoding(String templateFileEncoding) {
        this.templateFileEncoding = templateFileEncoding;
    }

    public File getTemplateFilePrimaryDir() {
        return this.templateFilePrimaryDir;
    }

    public void setTemplateFilePrimaryDir(File templateFilePrimaryDir) {
        this.templateFilePrimaryDir = templateFilePrimaryDir;
    }

    public String getTableNamePattern() {
        return this.tableNamePattern;
    }

    public void setTableNamePattern(String tableNamePattern) {
        this.tableNamePattern = tableNamePattern;
    }

    public String getIgnoreTableNamePattern() {
        return this.ignoreTableNamePattern;
    }

    public void setIgnoreTableNamePattern(String ignoreTableNamePattern) {
        this.ignoreTableNamePattern = ignoreTableNamePattern;
    }

    public String getVersionColumnNamePattern() {
        return this.versionColumnNamePattern;
    }

    public void setVersionColumnNamePattern(String versionColumnNamePattern) {
        this.versionColumnNamePattern = versionColumnNamePattern;
    }

    public File getPluralFormFile() {
        return this.pluralFormFile;
    }

    public void setPluralFormFile(File pluralFormFile) {
        this.pluralFormFile = pluralFormFile;
    }

    public boolean isShowCatalogName() {
        return this.showCatalogName;
    }

    public void setShowCatalogName(boolean showCatalogName) {
        this.showCatalogName = showCatalogName;
    }

    public boolean isShowSchemaName() {
        return this.showSchemaName;
    }

    public void setShowSchemaName(boolean showSchemaName) {
        this.showSchemaName = showSchemaName;
    }

    public boolean isShowTableName() {
        return this.showTableName;
    }

    public void setShowTableName(boolean showTableName) {
        this.showTableName = showTableName;
    }

    public boolean isShowColumnName() {
        return this.showColumnName;
    }

    public void setShowColumnName(boolean showColumnName) {
        this.showColumnName = showColumnName;
    }

    public boolean isShowColumnDefinition() {
        return this.showColumnDefinition;
    }

    public void setShowColumnDefinition(boolean showColumnDefinition) {
        this.showColumnDefinition = showColumnDefinition;
    }

    public boolean isShowJoinColumn() {
        return this.showJoinColumn;
    }

    public void setShowJoinColumn(boolean showJoinColumn) {
        this.showJoinColumn = showJoinColumn;
    }

    public String getGenDialectClassName() {
        return this.genDialectClassName;
    }

    public void setGenDialectClassName(String genDialectClassName) {
        this.genDialectClassName = genDialectClassName;
    }

    public GenerationType getGenerationType() {
        return this.generationType;
    }

    public void setGenerationType(GenerationType generationType) {
        this.generationType = generationType;
    }

    public Integer getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(Integer initialValue) {
        this.initialValue = initialValue;
    }

    public Integer getAllocationSize() {
        return this.allocationSize;
    }

    public void setAllocationSize(Integer allocationSize) {
        this.allocationSize = allocationSize;
    }

    public String getEntitySuperclassName() {
        return this.entitySuperclassName;
    }

    public void setEntitySuperclassName(String entitySuperclassName) {
        this.entitySuperclassName = entitySuperclassName;
    }

    public boolean isUseAccessor() {
        return this.useAccessor;
    }

    public void setUseAccessor(boolean useAccessor) {
        this.useAccessor = useAccessor;
    }

    public boolean isApplyDbCommentToJava() {
        return this.applyDbCommentToJava;
    }

    public void setApplyDbCommentToJava(boolean applyDbCommentToJava) {
        this.applyDbCommentToJava = applyDbCommentToJava;
    }

    public boolean isUseTemporalType() {
        return this.useTemporalType;
    }

    public void setUseTemporalType(boolean useTemporalType) {
        this.useTemporalType = useTemporalType;
    }

    protected void doValidate() {
    }

    protected void doInit() {
        this.dialect = this.getGenDialect(this.genDialectClassName);
        this.dbTableMetaReader = this.createDbTableMetaReader();
        this.entitySetDescFactory = this.createEntitySetDescFactory();
        this.generator = this.createGenerator();
        this.entityModelFactory = this.createEntityModelFactory();
        this.logRdbmsAndGenDialect(this.dialect);
    }

    protected void doExecute() {
        EntitySetDesc entitySetDesc = this.entitySetDescFactory.getEntitySetDesc();
        for (EntityDesc entityDesc : entitySetDesc.getEntityDescList()) {
            this.generateEntity(entityDesc);
        }
    }

    protected void doDestroy() {
    }

    protected void generateEntity(EntityDesc entityDesc) {
        EntityModel model = this.entityModelFactory.getEntityModel(entityDesc);
        GenerationContext context = this.createGenerationContext(model, this.entityTemplateFileName);
        this.generator.generate(context);
    }

    protected DbTableMetaReader createDbTableMetaReader() {
        return this.factory.createDbTableMetaReader(this, this.jdbcManager.getDataSource(), this.dialect, this.schemaName, this.tableNamePattern, this.ignoreTableNamePattern, this.applyDbCommentToJava);
    }

    protected EntitySetDescFactory createEntitySetDescFactory() {
        return this.factory.createEntitySetDescFactory(this, this.dbTableMetaReader, this.jdbcManager.getPersistenceConvention(), this.dialect, this.versionColumnNamePattern, this.pluralFormFile, this.generationType, this.initialValue, this.allocationSize);
    }

    protected EntityModelFactory createEntityModelFactory() {
        Class superClass = this.entitySuperclassName != null ? ClassUtil.forName((String)this.entitySuperclassName) : null;
        return this.factory.createEntityModelFactory(this, ClassUtil.concatName((String)this.rootPackageName, (String)this.entityPackageName), superClass, this.useTemporalType, this.useAccessor, this.applyDbCommentToJava, this.showCatalogName, this.showSchemaName, this.showTableName, this.showColumnName, this.showColumnDefinition, this.showJoinColumn, this.jdbcManager.getPersistenceConvention());
    }

    protected Generator createGenerator() {
        return this.factory.createGenerator(this, this.templateFileEncoding, this.templateFilePrimaryDir);
    }

    protected GenerationContext createGenerationContext(ClassModel model, String templateName) {
        File file = FileUtil.createJavaFile(this.javaFileDestDir, model.getPackageName(), model.getShortClassName());
        return this.factory.createGenerationContext(this, model, file, templateName, this.javaFileEncoding, this.overwrite);
    }

    protected Logger getLogger() {
        return logger;
    }
}

