/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.command;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import javax.sql.DataSource;
import org.seasar.extension.jdbc.gen.ProductInfo;
import org.seasar.extension.jdbc.gen.command.Command;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.dialect.GenDialectRegistry;
import org.seasar.extension.jdbc.gen.exception.CommandFailedRuntimeException;
import org.seasar.extension.jdbc.gen.internal.factory.Factory;
import org.seasar.extension.jdbc.gen.internal.factory.FactoryImpl;
import org.seasar.extension.jdbc.gen.internal.util.ReflectUtil;
import org.seasar.extension.jdbc.gen.internal.util.SingletonS2ContainerFactorySupport;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.extension.jdbc.util.DataSourceUtil;
import org.seasar.extension.jdbc.util.DatabaseMetaDataUtil;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.log.Logger;

public abstract class AbstractCommand
implements Command {
    protected String configPath = "s2jdbc.dicon";
    protected String env = "ut";
    protected String jdbcManagerName = "jdbcManager";
    protected String factoryClassName = FactoryImpl.class.getName();
    protected SingletonS2ContainerFactorySupport containerFactorySupport;
    protected JdbcManagerImplementor jdbcManager;
    protected Factory factory;

    public String getConfigPath() {
        return this.configPath;
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getJdbcManagerName() {
        return this.jdbcManagerName;
    }

    public void setJdbcManagerName(String jdbcManagerName) {
        this.jdbcManagerName = jdbcManagerName;
    }

    public String getFactoryClassName() {
        return this.factoryClassName;
    }

    public void setFactoryClassName(String factoryClassName) {
        this.factoryClassName = factoryClassName;
    }

    public final void execute() {
        ProductInfo info = ProductInfo.getInstance();
        this.getLogger().log("IS2JDBCGen0008", new Object[]{info.getName(), info.getVersion()});
        String commandClassName = this.getClass().getName();
        this.getLogger().log("DS2JDBCGen0003", new Object[]{commandClassName});
        this.logWritableProperties();
        this.validate();
        this.init();
        try {
            this.doExecute();
        }
        catch (Throwable t) {
            throw new CommandFailedRuntimeException(t, commandClassName);
        }
        finally {
            this.destroy();
        }
        this.getLogger().log("DS2JDBCGen0008", new Object[]{commandClassName});
    }

    protected void logWritableProperties() {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(this.getClass());
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc propertyDesc = beanDesc.getPropertyDesc(i);
            if (!propertyDesc.hasWriteMethod()) continue;
            this.getLogger().log("DS2JDBCGen0001", new Object[]{propertyDesc.getPropertyName(), propertyDesc.getValue((Object)this)});
        }
    }

    protected final void validate() {
        this.doValidate();
    }

    protected final void init() {
        this.factory = ReflectUtil.newInstance(Factory.class, this.factoryClassName);
        this.containerFactorySupport = new SingletonS2ContainerFactorySupport(this.configPath, this.env);
        this.containerFactorySupport.init();
        this.jdbcManager = (JdbcManagerImplementor)SingletonS2Container.getComponent((String)this.jdbcManagerName);
        this.doInit();
    }

    protected final void destroy() {
        this.doDestroy();
        if (this.containerFactorySupport != null) {
            this.containerFactorySupport.destory();
        }
    }

    protected void logRdbmsAndGenDialect(GenDialect dialect) {
        this.getLogger().log("DS2JDBCGen0005", new Object[]{this.getRdbmsName(), dialect.getClass().getName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getRdbmsName() {
        Connection conn = DataSourceUtil.getConnection((DataSource)this.jdbcManager.getDataSource());
        try {
            DatabaseMetaData metaData = ConnectionUtil.getMetaData((Connection)conn);
            String string = DatabaseMetaDataUtil.getDatabaseProductName((DatabaseMetaData)metaData);
            return string;
        }
        finally {
            ConnectionUtil.close((Connection)conn);
        }
    }

    protected GenDialect getGenDialect(String genDialectClassName) {
        if (genDialectClassName != null) {
            return ReflectUtil.newInstance(GenDialect.class, genDialectClassName);
        }
        return GenDialectRegistry.getGenDialect(this.jdbcManager.getDialect());
    }

    protected abstract void doValidate();

    protected abstract void doInit();

    protected abstract void doExecute() throws Throwable;

    protected abstract void doDestroy();

    protected abstract Logger getLogger();
}

