/*
 * Decompiled with CFR 0.152.
 */
package ow.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExpiringSet<T> {
    static final Logger logger = Logger.getLogger("util");
    private final Set<T> internalSet = Collections.synchronizedSet(new HashSet());
    private final long expiration;

    public ExpiringSet(long expiration) {
        this.expiration = expiration;
    }

    public void add(final T elem) {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ExpiringSet.this.internalSet.add(elem);
                try {
                    Thread.sleep(ExpiringSet.this.expiration);
                }
                catch (InterruptedException e) {
                    logger.log(Level.INFO, "Thread#sleep interrupted", e);
                }
                finally {
                    ExpiringSet.this.internalSet.remove(elem);
                }
            }
        };
        Thread t = new Thread(r);
        t.setName("Expirer on " + elem);
        t.setDaemon(true);
        t.start();
    }

    public boolean contains(T elem) {
        return this.internalSet.contains(elem);
    }

    public void clear() {
        this.internalSet.clear();
    }
}

