/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.util.toolframework;

import java.net.UnknownHostException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import ow.id.ID;
import ow.mcast.Mcast;
import ow.mcast.McastConfiguration;
import ow.mcast.McastFactory;
import ow.messaging.util.MessagingUtility;
import ow.stat.StatConfiguration;
import ow.stat.StatFactory;

public abstract class AbstractMcastBasedTool {
    private static final int MAX_ID_SIZE = 20;

    protected abstract void usage(String var1);

    protected void usage(String command, String optionDescriptions) {
        System.out.print("Usage: " + command);
        if (optionDescriptions != null) {
            System.out.print(" ");
            System.out.print(optionDescriptions);
        }
        System.out.println(" [-i <self ID>] [-m <stat collector addr>[:<port>]] [-t UDP|TCP] [-a algorithm name] [-r routing style] [-s [<self address>[:<port>]]|<port>] [--no-upnp] [<host>[:<port>]] [<port>]");
    }

    protected Options getInitialOptions() {
        Options opts = new Options();
        opts.addOption("h", "help", false, "print help");
        opts.addOption("i", "id", true, "self ID");
        opts.addOption("m", "statcollector", true, "address of stat collector");
        opts.addOption("t", "transport", true, "transport, UDP or TCP");
        opts.addOption("a", "algorithm", true, "routing algorithm");
        opts.addOption("r", "routingstyle", true, "routing style, Iterative or Recursive");
        opts.addOption("s", "selfaddress", true, "self IP address");
        opts.addOption("N", "no-upnp", false, "disable UPnP address port mapping");
        return opts;
    }

    public Mcast initialize(short applicationID, short applicationVersion, String command, CommandLine cmd) throws Exception {
        String[] args;
        String optVal;
        String transport = null;
        String algorithm = null;
        String routingStyle = null;
        ID selfID = null;
        String statCollectorAddressAndPort = null;
        String selfAddressAndPort = null;
        boolean noUPnP = false;
        boolean join = false;
        String contactHost = null;
        int contactPort = -1;
        String contactString = null;
        if (cmd.hasOption('h')) {
            this.usage(command);
            System.exit(1);
        }
        if ((optVal = cmd.getOptionValue('i')) != null) {
            selfID = ID.getID(optVal, 20);
        }
        if ((optVal = cmd.getOptionValue('m')) != null) {
            statCollectorAddressAndPort = optVal;
        }
        if ((optVal = cmd.getOptionValue('t')) != null) {
            transport = optVal;
        }
        if ((optVal = cmd.getOptionValue('a')) != null) {
            algorithm = optVal;
        }
        if ((optVal = cmd.getOptionValue('r')) != null) {
            routingStyle = optVal;
        }
        if ((optVal = cmd.getOptionValue('s')) != null) {
            selfAddressAndPort = optVal;
        }
        if (cmd.hasOption('N')) {
            noUPnP = true;
        }
        if ((args = cmd.getArgs()).length >= 1) {
            contactHost = args[0];
            join = true;
            if (args.length >= 2) {
                contactPort = Integer.parseInt(args[1]);
            }
        }
        McastConfiguration config = McastFactory.getDefaultConfiguration();
        if (transport != null) {
            config.setMessagingTransport(transport);
        }
        if (algorithm != null) {
            config.setRoutingAlgorithm(algorithm);
        }
        if (routingStyle != null) {
            config.setRoutingStyle(routingStyle);
        }
        if (selfAddressAndPort != null) {
            MessagingUtility.HostAndPort hostAndPort = MessagingUtility.parseHostnameAndPort(selfAddressAndPort, config.getSelfPort());
            config.setSelfAddress(hostAndPort.getHostName());
            config.setSelfPort(hostAndPort.getPort());
        }
        if (noUPnP) {
            config.setDoUPnPNATTraversal(false);
        }
        if (contactPort < 0) {
            contactPort = config.getSelfPort();
        }
        Mcast mcast = McastFactory.getMcast(applicationID, applicationVersion, config, selfID);
        StringBuilder sb = new StringBuilder();
        sb.append("Mcast configuration:\n");
        sb.append("  hostname:port:     ").append(mcast.getRoutingService().getSelfIDAddressPair().getAddress()).append('\n');
        sb.append("  transport type:    ").append(config.getMessagingTransport()).append('\n');
        sb.append("  routing algorithm: ").append(config.getRoutingAlgorithm()).append('\n');
        sb.append("  routing style:     ").append(config.getRoutingStyle()).append('\n');
        System.out.print(sb);
        try {
            if (statCollectorAddressAndPort != null) {
                StatConfiguration statConfig = StatFactory.getDefaultConfiguration();
                MessagingUtility.HostAndPort hostAndPort = MessagingUtility.parseHostnameAndPort(statCollectorAddressAndPort, statConfig.getSelfPort());
                mcast.setStatCollectorAddress(hostAndPort.getHostName(), hostAndPort.getPort());
            }
            if (join) {
                if (contactPort >= 0) {
                    mcast.joinOverlay(contactHost, contactPort);
                    contactString = contactHost + " : " + contactPort;
                } else {
                    try {
                        mcast.joinOverlay(contactHost);
                        contactString = contactHost;
                    }
                    catch (IllegalArgumentException e) {
                        contactPort = config.getContactPort();
                        mcast.joinOverlay(contactHost, contactPort);
                        contactString = contactHost + ":" + contactPort;
                    }
                }
            }
        }
        catch (UnknownHostException e) {
            System.err.println("A hostname could not be resolved: " + contactHost);
            e.printStackTrace();
            System.exit(1);
        }
        if (join) {
            System.out.println("  initial contact:   " + contactString);
        }
        System.out.println("A Mcast started.");
        System.out.flush();
        return mcast;
    }
}

