/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.util.shellframework;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.MessagingAddress;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingException;
import ow.routing.RoutingHop;
import ow.routing.RoutingResult;
import ow.routing.RoutingService;
import ow.routing.impl.IterativeRoutingDriver;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.Shell;
import ow.tool.util.shellframework.ShellContext;
import ow.tool.util.shellframework.ShellServer;
import ow.util.HighLevelService;
import ow.util.HighLevelServiceConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandUtil {
    public static <T extends HighLevelService> boolean executeHelp(ShellContext<T> context) {
        PrintStream out = context.getOutputStream();
        List<Command<T>> commandList = context.getCommandList();
        for (Command<T> command : commandList) {
            out.print(command.getHelp() + "\r\n");
        }
        out.flush();
        return false;
    }

    public static boolean executeInit(ShellContext<? extends HighLevelService> context, Command<?> cmd) throws UnknownHostException {
        HighLevelService svc = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        HighLevelServiceConfiguration config = svc.getConfiguration();
        int port = config.getSelfPort();
        if (args.length < 1) {
            out.print("usage: " + cmd.getHelp() + "\r\n");
            out.flush();
            return false;
        }
        if (args.length >= 2) {
            port = Integer.parseInt(args[1]);
        }
        MessagingAddress contactAddr = null;
        try {
            contactAddr = svc.joinOverlay(args[0], port);
        }
        catch (UnknownHostException e) {
            out.print("Hostname resolution failed on " + svc.getSelfIDAddressPair().getAddress() + "\r\n");
            out.flush();
            throw e;
        }
        catch (RoutingException e) {
            out.print("routing failed on " + svc.getSelfIDAddressPair() + "\r\n");
        }
        if (contactAddr != null) {
            out.print("contact: " + contactAddr.getHostAddress() + ":" + contactAddr.getPort() + "\r\n");
        } else {
            out.print("joining failed.\r\n");
        }
        out.flush();
        return false;
    }

    public static <T extends HighLevelService> boolean executeSource(ShellContext<T> context, Command<?> cmd) {
        ShellServer<T> shellServer = context.getShellServer();
        HighLevelService dht = (HighLevelService)context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 1) {
            out.print("usage: " + cmd.getHelp() + "\r\n");
            out.flush();
            return false;
        }
        if (shellServer != null) {
            for (int i = 0; i < args.length; ++i) {
                FileInputStream in;
                try {
                    in = new FileInputStream(args[0]);
                }
                catch (FileNotFoundException e) {
                    out.print("File not found: " + args[0] + "\r\n");
                    continue;
                }
                Shell<HighLevelService> subShell = new Shell<HighLevelService>(in, out, shellServer, dht, false);
                subShell.run();
            }
        }
        return false;
    }

    public static StringBuilder buildStatusMessage(HighLevelService svc, int verboseLevel) {
        RoutingService routingSvc = svc.getRoutingService();
        RoutingAlgorithmConfiguration algoConf = svc.getRoutingAlgorithmConfiguration();
        boolean iterative = routingSvc instanceof IterativeRoutingDriver;
        boolean adjustRoot = algoConf.adjustRoot();
        StringBuilder sb = new StringBuilder();
        sb.append("ID and address: ").append(svc.getSelfIDAddressPair().toString(verboseLevel)).append("\r\n");
        sb.append("Routing table:").append("\r\n");
        String routingTableString = svc.getRoutingTableString(verboseLevel).replaceAll("\n", "\r\n");
        sb.append(routingTableString).append("\r\n");
        ID[] keys = svc.getLastKeys();
        RoutingResult[] routingResults = svc.getLastRoutingResults();
        if (keys != null && routingResults != null) {
            sb.append("Last keys & routes: ").append("\r\n");
            sb.append("number of messages: ");
            int numOfMsgs = CommandUtil.calcNumOfMessagesWithoutCollectiveForwarding(routingResults, iterative, adjustRoot);
            sb.append(numOfMsgs);
            sb.append(" -> ");
            numOfMsgs = CommandUtil.calcNumOfMessagesWithCollectiveForwarding(routingResults, iterative, adjustRoot);
            sb.append(numOfMsgs);
            sb.append("\r\n");
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i] == null || routingResults[i] == null) continue;
                sb.append("key[").append(i).append("]: ");
                sb.append(keys[i].toString(verboseLevel)).append("\r\n");
                RoutingHop[] route = routingResults[i].getRoute();
                sb.append("route[").append(i).append("] (length: ").append(route.length - 1).append("): ");
                sb.append("[");
                long timeBase = -1L;
                for (RoutingHop routingHop : route) {
                    if (timeBase < 0L) {
                        timeBase = routingHop.getTime();
                    }
                    sb.append("\r\n").append(" ");
                    sb.append(routingHop.getIDAddressPair().toString(verboseLevel));
                    sb.append(" (").append(routingHop.getTime() - timeBase).append(")");
                }
                sb.append("\r\n").append("]").append("\r\n");
                sb.append("root candidates[").append(i).append("]: ");
                sb.append("[");
                for (Serializable serializable : routingResults[i].getRootCandidates()) {
                    sb.append("\r\n").append(" ");
                    sb.append(((IDAddressPair)serializable).toString(verboseLevel));
                }
                sb.append("\r\n").append("]").append("\r\n");
            }
        }
        return sb;
    }

    private static int calcNumOfMessagesWithoutCollectiveForwarding(RoutingResult[] results, boolean iterative, boolean adjustLastHop) {
        int num = 0;
        for (int i = 0; i < results.length; ++i) {
            int lastIndex;
            IDAddressPair h;
            RoutingHop[] route;
            if (results[i] == null || (route = results[i].getRoute()).length <= 0) continue;
            IDAddressPair self = route[0].getIDAddressPair();
            for (int j = 0; j < route.length - 1; ++j) {
                h = route[j].getIDAddressPair();
                if (self.equals(h)) continue;
                num += 2;
            }
            if (iterative && adjustLastHop) {
                int preLastIndex = route.length - 2;
                if (preLastIndex < 0) {
                    preLastIndex = 0;
                }
                if (!self.equals(h = route[preLastIndex].getIDAddressPair())) {
                    num += 2;
                }
            }
            if ((lastIndex = route.length - 1) < 0) {
                lastIndex = 0;
            }
            if (self.equals(h = route[lastIndex].getIDAddressPair())) continue;
            if (iterative) {
                num += 2;
                continue;
            }
            num += 3;
        }
        return num;
    }

    private static int calcNumOfMessagesWithCollectiveForwarding(RoutingResult[] results, boolean iterative, boolean adjustLastHop) {
        int num = 0;
        IDAddressPair self = null;
        if (iterative && adjustLastHop) {
            HashSet<IDAddressPair> lastHops = new HashSet<IDAddressPair>();
            HashSet<IDAddressPair> preLastHops = new HashSet<IDAddressPair>();
            for (int i = 0; i < results.length; ++i) {
                if (results[i] == null) continue;
                RoutingHop[] route = results[i].getRoute();
                int len = route.length;
                preLastHops.add(route[route.length >= 2 ? len - 2 : len - 1].getIDAddressPair());
                lastHops.add(route[len - 1].getIDAddressPair());
                if (self != null) continue;
                self = route[0].getIDAddressPair();
            }
            preLastHops.remove(self);
            lastHops.remove(self);
            num += 2 * preLastHops.size();
            num += 2 * lastHops.size();
        }
        ArrayList<List<RoutingHop>> routes = new ArrayList<List<RoutingHop>>();
        for (int i = 0; i < results.length; ++i) {
            if (results[i] == null || results[i].getRoute().length <= 1) continue;
            ArrayList<RoutingHop> l = new ArrayList<RoutingHop>();
            boolean firstElem = true;
            for (RoutingHop h : results[i].getRoute()) {
                if (firstElem) {
                    if (self == null) {
                        self = h.getIDAddressPair();
                    }
                    firstElem = false;
                    continue;
                }
                l.add(h);
            }
            if (iterative && adjustLastHop) {
                l.remove(l.size() - 1);
            }
            if (l.isEmpty()) continue;
            routes.add(l);
        }
        return num += CommandUtil.calcNumOfMessagesWithCollectiveForwarding(routes, iterative, self);
    }

    private static int calcNumOfMessagesWithCollectiveForwarding(List<List<RoutingHop>> routes, boolean iterative, IDAddressPair self) {
        HashSet<IDAddressPair> firstHopSet = new HashSet<IDAddressPair>();
        for (List<RoutingHop> l : routes) {
            RoutingHop h = l.get(0);
            IDAddressPair firstHop = h.getIDAddressPair();
            if (self.equals(firstHop)) continue;
            firstHopSet.add(firstHop);
        }
        int num = 2 * firstHopSet.size();
        ArrayList<List<RoutingHop>> partOfRoutes = new ArrayList<List<RoutingHop>>();
        for (IDAddressPair p : firstHopSet) {
            boolean reachAndCountLastHop = false;
            partOfRoutes.clear();
            Iterator<List<RoutingHop>> itr = routes.iterator();
            while (itr.hasNext()) {
                List<RoutingHop> l = itr.next();
                RoutingHop h = l.get(0);
                IDAddressPair firstHop = h.getIDAddressPair();
                if (!p.equals(firstHop)) continue;
                itr.remove();
                l.remove(0);
                if (l.isEmpty()) {
                    if (self.equals(firstHop)) continue;
                    reachAndCountLastHop = true;
                    continue;
                }
                partOfRoutes.add(l);
            }
            if (!iterative && reachAndCountLastHop) {
                ++num;
            }
            if (partOfRoutes.isEmpty()) continue;
            num += CommandUtil.calcNumOfMessagesWithCollectiveForwarding(partOfRoutes, iterative, self);
        }
        return num;
    }
}

