/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.msgcounter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import ow.messaging.MessagingAddress;
import ow.messaging.Tag;
import ow.stat.MessagingCallback;
import ow.stat.MessagingCollector;
import ow.stat.StatConfiguration;
import ow.stat.StatFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageCounter
implements MessagingCallback {
    private final StatConfiguration config;
    private MessagingCollector statCollector = null;
    private final Map<Integer, CounterEntry> totalCounterMap = new HashMap<Integer, CounterEntry>();
    private final Map<Integer, CounterEntry> lapCounterMap = new HashMap<Integer, CounterEntry>();
    private final SortedSet<Integer> tagSet = new TreeSet<Integer>();
    private final Set<MessagingAddress> nodeSet = new HashSet<MessagingAddress>();
    private int maxNumNode = 0;
    private boolean showLength;

    public MessageCounter(String transport, boolean noUPnP) {
        this.config = StatFactory.getDefaultConfiguration();
        if (transport != null) {
            this.config.setMessagingTransport(transport);
        }
        this.config.setDoUPnPNATTraversal(!noUPnP);
    }

    public void start() throws Exception {
        if (this.statCollector == null) {
            this.statCollector = StatFactory.getMessagingCollector(this.config);
            this.statCollector.start(this);
        }
    }

    public void stop() {
        if (this.statCollector != null) {
            this.statCollector.stop();
            this.statCollector = null;
        }
    }

    public synchronized void clear() {
        this.totalCounterMap.clear();
        this.lapCounterMap.clear();
        this.tagSet.clear();
    }

    @Override
    public synchronized void messageSent(MessagingAddress source, MessagingAddress target, int tag, int len) {
        if (len > 0) {
            this.showLength = true;
        }
        int attribute = Thread.currentThread().isDaemon() ? 2 : 1;
        this.count(this.totalCounterMap, tag, len, attribute);
        this.count(this.lapCounterMap, tag, len, attribute);
        this.nodeSet.add(source);
        int size = this.nodeSet.size();
        if (size > this.maxNumNode) {
            this.maxNumNode = size;
        }
    }

    private void count(Map<Integer, CounterEntry> map, int tag, int len, int attribute) {
        CounterEntry c = map.get(tag);
        if (c == null) {
            c = new CounterEntry();
            map.put(tag, c);
            this.tagSet.add(tag);
        }
        c.count(len, attribute);
    }

    @Override
    public void nodeFailed(MessagingAddress node) {
        this.nodeSet.remove(node);
    }

    public synchronized String getCountsString(boolean verbose) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        int numNodes = this.nodeSet.size();
        this.appendCountsString(sb, "lap", this.lapCounterMap, 0, numNodes);
        if (verbose) {
            this.appendCountsString(sb, "lap:nondaemon", this.lapCounterMap, 1, numNodes);
            this.appendCountsString(sb, "lap:daemon", this.lapCounterMap, 2, numNodes);
        }
        this.lapCounterMap.clear();
        this.appendCountsString(sb, "total", this.totalCounterMap, 0, this.maxNumNode);
        return sb.toString();
    }

    private StringBuilder appendCountsString(StringBuilder sb, String label, Map<Integer, CounterEntry> map, int matchingAttribute, int numNodes) {
        int sumNumber = 0;
        int sumLength = 0;
        sb.append("Message count");
        if (this.showLength) {
            sb.append(" & length in byte");
        }
        sb.append(" (").append(label).append("):\n");
        for (Integer i : this.tagSet) {
            int number;
            CounterEntry c = map.get(i);
            if (c == null || matchingAttribute > 0 && c.getAttribute() != matchingAttribute || (number = c.getNumber()) == 0) continue;
            sumNumber += number;
            sb.append(Tag.getNameByNumber(i));
            sb.append(", ");
            sb.append(number);
            if (this.showLength) {
                int length = c.getLength();
                sumLength += length;
                sb.append(", ");
                sb.append(length);
            }
            sb.append("\n");
        }
        sb.append("message count");
        if (this.showLength) {
            sb.append(", length");
        }
        sb.append(" & # of nodes (").append(label).append("), ");
        sb.append(sumNumber);
        if (this.showLength) {
            sb.append(", ");
            sb.append(sumLength);
        }
        sb.append(", ");
        sb.append(numNodes);
        sb.append("\n\n");
        return sb;
    }

    private final class CounterEntry {
        public static final int ATTR_NONDAEMON = 1;
        public static final int ATTR_DAEMON = 2;
        private int number = 0;
        private int length = 0;
        private int attribute = 0;

        private CounterEntry() {
        }

        public int getNumber() {
            return this.number;
        }

        public int getLength() {
            return this.length;
        }

        public int getAttribute() {
            return this.attribute;
        }

        public void count(int len, int attribute) {
            ++this.number;
            this.length += len;
            this.attribute = attribute;
        }
    }
}

