/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.emulator.commands;

import java.io.PrintStream;
import java.lang.reflect.Method;
import ow.tool.emulator.EmulatorContext;
import ow.tool.emulator.EmulatorMode;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassCommand
implements Command<EmulatorContext> {
    private static final String[] NAMES = new String[]{"class"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "class <class name>";
    }

    @Override
    public boolean execute(ShellContext<EmulatorContext> context) {
        Class<?> clazz;
        EmulatorContext cxt = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 1) {
            out.println("class command needs an argument.");
            return !context.isInteractive();
        }
        try {
            clazz = Class.forName(args[0]);
        }
        catch (ClassNotFoundException e) {
            out.println("No such class: " + args[0]);
            return !context.isInteractive();
        }
        Method mainMethod = null;
        try {
            mainMethod = clazz.getMethod("main", Class.forName("[Ljava.lang.String;"));
        }
        catch (Exception e) {
            // empty catch block
        }
        cxt.setCurrentClass(clazz);
        cxt.setCurrentMainMethod(mainMethod);
        if (cxt.getEmulatorMode() != EmulatorMode.WORKER && cxt.getVerboseInParsing()) {
            out.print("class: ");
            out.println(args[0]);
        }
        return false;
    }
}

