/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.plaxton;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.util.List;
import java.util.logging.Level;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingContext;
import ow.routing.RoutingService;
import ow.routing.impl.AbstractRoutingAlgorithm;
import ow.routing.plaxton.PlaxtonConfiguration;
import ow.routing.plaxton.RoutingTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Plaxton
extends AbstractRoutingAlgorithm {
    private PlaxtonConfiguration config;
    protected boolean stopped = false;
    protected boolean suspended = true;
    protected final int idSizeInBit;
    protected final int idSizeInDigit;
    protected final int digitSize;
    protected final RoutingTable routingTable;

    protected Plaxton(RoutingAlgorithmConfiguration config, RoutingService routingSvc) throws InvalidAlgorithmParameterException {
        super(config, routingSvc);
        try {
            this.config = (PlaxtonConfiguration)config;
        }
        catch (ClassCastException e) {
            throw new InvalidAlgorithmParameterException("The given config is not KademliaConfiguration.");
        }
        this.idSizeInBit = config.getIDSizeInByte() * 8;
        this.idSizeInDigit = (this.idSizeInBit - 1) / this.config.getDigitSize() + 1;
        this.digitSize = this.config.getDigitSize();
        if (routingSvc != null) {
            this.routingTable = new RoutingTable(this.idSizeInDigit, this.digitSize, routingSvc.getSelfIDAddressPair(), this);
        } else {
            logger.log(Level.SEVERE, "routingSvc is null. test?");
            this.routingTable = null;
        }
    }

    @Override
    public void reset() {
        this.routingTable.clear();
    }

    @Override
    public IDAddressPair[] closestTo(ID target, int maxNum, RoutingContext cxt) {
        IDAddressPair[] downwardNodes;
        int nMatchBits = ID.matchLengthFromMSB(this.selfIDAddress.getID(), target);
        int nMatchDigits = nMatchBits / this.digitSize;
        int notMatchDigit = this.getDigit(target, nMatchDigits);
        List<IDAddressPair> results = null;
        if (nMatchDigits < this.idSizeInDigit) {
            results = this.traverseDownward(nMatchDigits, notMatchDigit, target, maxNum);
        }
        if (results != null && results.size() > 0) {
            downwardNodes = new IDAddressPair[results.size()];
            results.toArray(downwardNodes);
        } else {
            downwardNodes = new IDAddressPair[]{this.selfIDAddress};
        }
        if (downwardNodes.length >= maxNum) {
            return downwardNodes;
        }
        IDAddressPair[] upwardNodes = null;
        List<IDAddressPair> upwardNodesList = this.traverseUpward(nMatchDigits, maxNum - downwardNodes.length);
        upwardNodes = new IDAddressPair[upwardNodesList.size()];
        upwardNodesList.toArray(upwardNodes);
        int numUpwardNodes = upwardNodes == null ? 0 : upwardNodes.length;
        IDAddressPair[] ret = new IDAddressPair[downwardNodes.length + numUpwardNodes];
        System.arraycopy(downwardNodes, 0, ret, 0, downwardNodes.length);
        if (upwardNodes != null) {
            System.arraycopy(upwardNodes, 0, ret, downwardNodes.length, numUpwardNodes);
        }
        return ret;
    }

    @Override
    public IDAddressPair[] rootCandidates(ID target, int maxNum) {
        return this.closestTo(target, maxNum, null);
    }

    protected abstract List<IDAddressPair> traverseDownward(int var1, int var2, ID var3, int var4);

    protected abstract List<IDAddressPair> traverseUpward(int var1, int var2);

    @Override
    public void stop() {
        this.stopped = true;
    }

    @Override
    public synchronized void suspend() {
        this.suspended = true;
    }

    @Override
    public synchronized void resume() {
        this.suspended = false;
        this.notifyAll();
    }

    @Override
    public IDAddressPair[] adjustRoot(ID rootCandidate) {
        return null;
    }

    @Override
    public boolean toReplace(IDAddressPair existingEntry, IDAddressPair newEntry) {
        return random.nextDouble() < this.config.getReplaceProbability();
    }

    @Override
    public void join(IDAddressPair[] neighbors) {
        this.resume();
    }

    @Override
    public void join(IDAddressPair joiningNode, IDAddressPair lastHop, boolean isRootNode) {
        ID joiningNodeID;
        ID iD = joiningNodeID = joiningNode != null ? joiningNode.getID() : null;
        if (!this.selfIDAddress.getID().equals(joiningNodeID)) {
            this.resume();
        }
    }

    @Override
    public void touch(IDAddressPair from) {
        this.routingTable.merge(from);
    }

    @Override
    public void forget(IDAddressPair failedNode) {
        this.routingTable.remove(failedNode);
    }

    @Override
    public String getRoutingTableString(int verboseLevel) {
        return this.routingTable.toString(verboseLevel);
    }

    @Override
    public String getRoutingTableHTMLString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<h4>Plaxton Routing Table</h5>\n");
        sb.append(this.routingTable.toHTMLString());
        return sb.toString();
    }

    protected void prepareHandlers() {
    }

    public int getDigit(ID id, int index) {
        return id.getBits(this.idSizeInBit - (index + 1) * this.digitSize, this.digitSize);
    }

    public ID setDigit(ID id, int index, int digit) {
        int bitOffset = this.idSizeInBit - (index + 1) * this.digitSize;
        BigInteger mask = BigInteger.valueOf(~(-1 << this.digitSize));
        mask = mask.shiftLeft(bitOffset);
        BigInteger digitInt = BigInteger.valueOf(digit);
        digitInt = digitInt.shiftLeft(bitOffset);
        BigInteger v = id.toBigInteger();
        v = v.andNot(mask);
        v = v.or(digitInt);
        return ID.getID(v, id.getSize());
    }
}

