/*
 * Decompiled with CFR 0.152.
 */
package ow.routing;

import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.routing.RoutingAlgorithmProvider;
import ow.routing.chord.ChordProvider;
import ow.routing.kademlia.KademliaProvider;
import ow.routing.koorde.KoordeProvider;
import ow.routing.linearwalker.LinearWalkerProvider;
import ow.routing.pastry.PastryProvider;
import ow.routing.tapestry.TapestryProvider;

public class RoutingAlgorithmFactory {
    private static final Logger logger = Logger.getLogger("routing");
    private static final Class[] PROVIDERS = new Class[]{ChordProvider.class, KademliaProvider.class, KoordeProvider.class, LinearWalkerProvider.class, PastryProvider.class, TapestryProvider.class};
    private static final Map<String, RoutingAlgorithmProvider> providerTable = new HashMap<String, RoutingAlgorithmProvider>();
    private static final Map<String, Integer> idTable = new HashMap<String, Integer>();

    public static RoutingAlgorithmProvider getProvider(String algorithmName) throws NoSuchProviderException {
        RoutingAlgorithmProvider provider = providerTable.get(algorithmName);
        if (provider == null) {
            throw new NoSuchProviderException("No such algorithm: " + algorithmName);
        }
        return provider;
    }

    public static byte getAlgorithmID(String algorithmName) throws NoSuchProviderException {
        Integer idInteger = idTable.get(algorithmName);
        if (idInteger == null && idInteger == null) {
            throw new NoSuchProviderException("No such algorithm: " + algorithmName);
        }
        return (byte)idInteger.intValue();
    }

    static {
        int id = 1;
        for (Class clazz : PROVIDERS) {
            Object o;
            try {
                o = clazz.newInstance();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not instantiate an object of the class: " + clazz, e);
                continue;
            }
            if (!(o instanceof RoutingAlgorithmProvider)) continue;
            RoutingAlgorithmProvider provider = (RoutingAlgorithmProvider)o;
            providerTable.put(provider.getName(), provider);
            idTable.put(provider.getName(), id);
            ++id;
        }
    }
}

