/*
 * Decompiled with CFR 0.152.
 */
package ow.directory;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ow.directory.MultiValueDirectory;
import ow.directory.SingleValueDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiValueAdapterForSingleValueDirectory<K, V>
implements MultiValueDirectory<K, V> {
    private final SingleValueDirectory<K, V> dir;

    public MultiValueAdapterForSingleValueDirectory(SingleValueDirectory<K, V> dir) {
        this.dir = dir;
    }

    @Override
    public Set<V> get(K key) throws Exception {
        V value = this.dir.get(key);
        HashSet<V> ret = null;
        if (value != null) {
            ret = new HashSet<V>();
            ret.add(value);
        }
        return ret;
    }

    @Override
    public V remove(K key, V value) throws Exception {
        if (value != null && value.equals(this.dir.get(key))) {
            return this.dir.remove(key);
        }
        return null;
    }

    @Override
    public Set<V> remove(K key) throws Exception {
        V value = this.dir.remove(key);
        HashSet<V> ret = null;
        if (value != null) {
            ret = new HashSet<V>();
            ret.add(value);
        }
        return ret;
    }

    @Override
    public V put(K key, V value) throws Exception {
        return this.dir.put(key, value);
    }

    @Override
    public V put(K key, V value, long ttl) throws Exception {
        return this.dir.put(key, value, ttl);
    }

    @Override
    public boolean isEmpty() {
        return this.dir.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.dir.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.dir.entrySet();
    }

    @Override
    public void clear() {
        this.dir.clear();
    }

    @Override
    public void close() {
        this.dir.close();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.dir.iterator();
    }
}

