/*
 * Decompiled with CFR 0.152.
 */
package ow.dht.impl;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import ow.dht.ByteArray;
import ow.dht.DHT;
import ow.dht.DHTConfiguration;
import ow.dht.ValueInfo;
import ow.dht.impl.BasicDHTImpl;
import ow.dht.impl.DHTMessageFactory;
import ow.directory.DirectoryConfiguration;
import ow.directory.DirectoryFactory;
import ow.directory.DirectoryProvider;
import ow.directory.MultiValueAdapterForSingleValueDirectory;
import ow.directory.MultiValueDirectory;
import ow.directory.SingleValueDirectory;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.MessagingAddress;
import ow.messaging.Tag;
import ow.routing.RoutingAlgorithm;
import ow.routing.RoutingException;
import ow.routing.RoutingResult;
import ow.routing.RoutingService;
import ow.util.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChurnTolerantDHTImpl<V extends Serializable>
extends BasicDHTImpl<V> {
    private static final String LOCAL_DB_NAME = "local";
    private MultiValueDirectory<ID, ValueInfo<V>> localDir = null;
    private static Timer timer = null;
    private Thread reputterThread = null;

    public ChurnTolerantDHTImpl(short applicationID, short applicationVersion, DHTConfiguration config, ID selfID) throws Exception {
        super(applicationID, applicationVersion, config, selfID);
    }

    public ChurnTolerantDHTImpl(DHTConfiguration config, RoutingService routingSvc) throws Exception {
        super(config, routingSvc);
    }

    @Override
    protected void init(DHTConfiguration config, RoutingService routingSvc) throws Exception {
        super.init(config, routingSvc);
        DirectoryProvider dirProvider = DirectoryFactory.getProvider(config.getDirectoryType());
        DirectoryConfiguration dirConfig = DirectoryConfiguration.getDefaultConfiguration();
        if (config.getDoExpire()) {
            dirConfig.setExpirationTime(config.getDefaultTTL());
        } else {
            dirConfig.setExpirationTime(-1L);
        }
        if (this.config.getDoReputOnRequester()) {
            if (config.getMultipleValuesForASingleKey()) {
                this.localDir = dirProvider.openMultiValueDirectory(ID.class, ValueInfo.class, config.getWorkingDirectory(), LOCAL_DB_NAME, dirConfig);
            } else {
                SingleValueDirectory singleValueDir = dirProvider.openSingleValueDirectory(ID.class, config.getValueClass(), config.getWorkingDirectory(), LOCAL_DB_NAME, dirConfig);
                this.localDir = new MultiValueAdapterForSingleValueDirectory<ID, ValueInfo<V>>(singleValueDir);
            }
        }
        this.startReputter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void startReputter() {
        if (this.config.getReputInterval() > 0L && (this.config.getDoReputOnRequester() || this.config.getDoReputOnReplicas())) {
            Reputter r = new Reputter();
            if (this.config.getUseTimerInsteadOfThread()) {
                Class<BasicDHTImpl> clazz = BasicDHTImpl.class;
                synchronized (BasicDHTImpl.class) {
                    if (timer == null) {
                        timer = new Timer("Reputting timer", true);
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    timer.schedule(r, System.currentTimeMillis(), true);
                }
            } else {
                this.reputterThread = new Thread(r);
                this.reputterThread.setName("Reputter on " + this.getSelfIDAddressPair().getAddress());
                this.reputterThread.setDaemon(true);
                this.reputterThread.start();
            }
        }
    }

    private synchronized void stopReputter() {
        if (this.reputterThread != null) {
            this.reputterThread.interrupt();
            this.reputterThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDHTState() {
        super.clearDHTState();
        if (this.localDir != null) {
            MultiValueDirectory<ID, ValueInfo<V>> multiValueDirectory = this.localDir;
            synchronized (multiValueDirectory) {
                this.localDir.clear();
            }
        }
    }

    @Override
    public Set<ValueInfo<V>>[] get(ID[] keys) {
        Set[] results = new Set[keys.length];
        RoutingResult[] routingRes = super.getRemotely(keys, results);
        int numTimesGets = this.config.getNumTimesGets() - 1;
        if (numTimesGets > 0) {
            Queue[] rootCands = new Queue[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                if (routingRes[i] == null) continue;
                for (IDAddressPair p : routingRes[i].getRootCandidates()) {
                    if (rootCands[i] == null) {
                        rootCands[i] = new LinkedList();
                        continue;
                    }
                    rootCands[i].add(p);
                }
            }
            this.requestReplicas(results, keys, rootCands, numTimesGets);
        }
        return results;
    }

    /*
     * Exception decompiling
     */
    private void requestReplicas(Set<ValueInfo<V>>[] resultSet, ID[] keys, Queue<IDAddressPair>[] rootCands, int numTimesGets) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[UNCONDITIONALDOLOOP]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValueInfo<V>> put(ID key, V[] values) throws IOException {
        int repeat;
        int numReplica;
        if (this.localDir != null) {
            MultiValueDirectory<ID, ValueInfo<V>> multiValueDirectory = this.localDir;
            synchronized (multiValueDirectory) {
                for (V v : values) {
                    try {
                        this.localDir.put(key, new ValueInfo<V>(v, this.ttlForPut, this.hashedSecretForPut));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        DHT.PutRequest[] requests = new DHT.PutRequest[]{new DHT.PutRequest<V>(key, values)};
        if (this.config.getRootDoesReplication()) {
            numReplica = this.config.getNumReplica();
            repeat = 1;
        } else {
            numReplica = 1;
            repeat = this.config.getNumReplica();
        }
        Set<ValueInfo<V>>[] ret = this.putOrRemoveRemotely(requests, false, this.ttlForPut, this.hashedSecretForPut, true, numReplica, repeat, false);
        if (ret[0] == null) {
            throw new RoutingException();
        }
        return ret[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValueInfo<V>>[] put(DHT.PutRequest<V>[] requests) throws IOException {
        int repeat;
        int numReplica;
        if (this.localDir != null) {
            MultiValueDirectory<ID, ValueInfo<V>> multiValueDirectory = this.localDir;
            synchronized (multiValueDirectory) {
                for (DHT.PutRequest<V> req : requests) {
                    for (Serializable v : (Serializable[])req.getValues()) {
                        try {
                            this.localDir.put(req.getKey(), new ValueInfo<Serializable>(v, this.ttlForPut, this.hashedSecretForPut));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (this.config.getRootDoesReplication()) {
            numReplica = this.config.getNumReplica();
            repeat = 1;
        } else {
            numReplica = 1;
            repeat = this.config.getNumReplica();
        }
        return this.putOrRemoveRemotely(requests, false, this.ttlForPut, this.hashedSecretForPut, true, numReplica, repeat, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<ValueInfo<V>>[] remove(DHT.RemoveRequest<V>[] requests, ByteArray hashedSecret) {
        int repeat;
        int numReplica;
        if (this.localDir != null) {
            for (int i = 0; i < requests.length; ++i) {
                DHT.RemoveRequest<V> req = requests[i];
                try {
                    if (req.getValues() != null) {
                        MultiValueDirectory<ID, ValueInfo<V>> multiValueDirectory = this.localDir;
                        synchronized (multiValueDirectory) {
                            for (Serializable v : (Serializable[])req.getValues()) {
                                this.localDir.remove(req.getKey(), new ValueInfo<Serializable>(v, -1L, hashedSecret));
                            }
                            continue;
                        }
                    }
                    Set<ValueInfo<V>> localValues = this.localDir.get(req.getKey());
                    if (localValues == null) continue;
                    for (ValueInfo<V> v : localValues) {
                        ID h = null;
                        try {
                            h = ID.getSHA1BasedID(v.getValue().toString().getBytes(this.config.getValueEncoding()));
                        }
                        catch (UnsupportedEncodingException e) {
                            logger.log(Level.SEVERE, "Encoding not supported: " + this.config.getValueEncoding());
                        }
                        if (req.getValueHash() != null && !h.equals(req.getValueHash()) || !hashedSecret.equals(v.getHashedSecret())) continue;
                        MultiValueDirectory<ID, ValueInfo<V>> multiValueDirectory = this.localDir;
                        synchronized (multiValueDirectory) {
                            this.localDir.remove(req.getKey(), v);
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "An Exception thrown by Directory#remove().", e);
                }
            }
        }
        if (this.config.getRootDoesReplication()) {
            numReplica = this.config.getNumReplica();
            repeat = 1;
            return this.putOrRemoveRemotely(requests, true, 0L, hashedSecret, true, numReplica, repeat, false);
        } else {
            numReplica = 1;
            repeat = this.config.getNumReplica();
        }
        return this.putOrRemoveRemotely(requests, true, 0L, hashedSecret, true, numReplica, repeat, false);
    }

    @Override
    public synchronized void stop() {
        this.stopReputter();
        super.stop();
        if (this.localDir != null) {
            this.localDir.close();
            this.localDir = null;
        }
    }

    @Override
    public synchronized void suspend() {
        this.stopReputter();
        super.suspend();
    }

    @Override
    public synchronized void resume() {
        super.resume();
        this.startReputter();
    }

    @Override
    public Set<ID> getLocalKeys() {
        if (this.localDir == null) {
            return null;
        }
        return this.localDir.keySet();
    }

    @Override
    public Set<ValueInfo<V>> getLocalValues(ID key) {
        if (this.localDir == null) {
            return null;
        }
        Set<ValueInfo<V>> ret = null;
        try {
            ret = this.localDir.get(key);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "An Exception thrown when retrieve from the localDir.", e);
            return null;
        }
        return ret;
    }

    @Override
    protected void prepareHandlers(RoutingService routingSvc) {
        super.prepareHandlers0(routingSvc);
        MessageHandler handler = new PutMessageHandler();
        routingSvc.addMessageHandler(Tag.PUT.getNumber(), handler);
        handler = new RemoveMessageHandler();
        routingSvc.addMessageHandler(Tag.REMOVE.getNumber(), handler);
        handler = new MessageHandler(){

            public Message process(Message msg) {
                Map valueMap = ChurnTolerantDHTImpl.this.getValueLocallyToBeTransferredTo(msg.getSource().getID());
                MessagingAddress src = msg.getSource().getAddress();
                Message putValueInfoMsg = DHTMessageFactory.getPutValueInfoMessage(ChurnTolerantDHTImpl.this.getSelfIDAddressPair(), valueMap);
                try {
                    ChurnTolerantDHTImpl.this.sender.send(src, putValueInfoMsg);
                }
                catch (IOException e) {
                    BasicDHTImpl.logger.log(Level.WARNING, "failed to send a PUT_VALUEINFO msg: " + src);
                }
                return null;
            }
        };
        routingSvc.addMessageHandler(Tag.REQ_TRANSFER.getNumber(), handler);
        handler = new PutValueInfoMessageHandler();
        routingSvc.addMessageHandler(Tag.PUT_VALUEINFO.getNumber(), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ID, Set<ValueInfo<V>>> getValueLocallyToBeTransferredTo(ID otherID) {
        ID selfID = this.getSelfIDAddressPair().getID();
        RoutingAlgorithm algo = this.routingSvc.getRoutingAlgorithm();
        HashMap results = null;
        ID[] keys = null;
        MultiValueDirectory multiValueDirectory = this.globalDir;
        synchronized (multiValueDirectory) {
            Set keySet = this.globalDir.keySet();
            if (keySet != null) {
                keys = new ID[keySet.size()];
                keySet.toArray(keys);
            }
        }
        block5: for (ID k : keys) {
            IDAddressPair[] betterRoot = algo.rootCandidates(k, this.config.getNumReplica() + 1);
            if (betterRoot == null || betterRoot.length <= 0) continue;
            for (IDAddressPair p : betterRoot) {
                if (otherID.equals(p.getID())) {
                    try {
                        Set s = this.globalDir.get(k);
                        if (s == null) continue;
                        if (results == null) {
                            results = new HashMap();
                        }
                        results.put(k, s);
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (selfID.equals(p.getID())) continue block5;
            }
        }
        return results;
    }

    private class Reputter
    implements Runnable {
        private final Random rnd = new Random();
        private final boolean reputOnRequester;

        public Reputter() {
            this.reputOnRequester = ChurnTolerantDHTImpl.this.config.getDoReputOnRequester();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BasicDHTImpl.logger.log(Level.INFO, "Reputter woke up.");
            try {
                if (!ChurnTolerantDHTImpl.this.config.getUseTimerInsteadOfThread()) {
                    Thread.sleep((long)((double)ChurnTolerantDHTImpl.this.config.getReputInterval() * 0.5));
                }
                while (!ChurnTolerantDHTImpl.this.stopped && !ChurnTolerantDHTImpl.this.suspended) {
                    MultiValueDirectory dir = this.reputOnRequester ? ChurnTolerantDHTImpl.this.localDir : ChurnTolerantDHTImpl.this.globalDir;
                    ID[] keys = null;
                    MultiValueDirectory multiValueDirectory = dir;
                    synchronized (multiValueDirectory) {
                        Set keySet = dir.keySet();
                        if (keySet != null && keySet.size() > 0) {
                            keys = new ID[keySet.size()];
                            keySet.toArray(keys);
                        }
                    }
                    if (keys != null) {
                        for (ID key : keys) {
                            Set valueSet = ChurnTolerantDHTImpl.this.getValueLocally(key, dir);
                            if (valueSet == null) continue;
                            HashSet<ValueInfo.Attributes> attrSet = new HashSet<ValueInfo.Attributes>();
                            for (ValueInfo v : valueSet) {
                                attrSet.add(v.getAttributes());
                            }
                            for (ValueInfo.Attributes attr : attrSet) {
                                int repeat;
                                int numReplica;
                                HashSet vSet = new HashSet();
                                for (ValueInfo v : valueSet) {
                                    if (!attr.equals(v.getAttributes())) continue;
                                    vSet.add(v.getValue());
                                }
                                Serializable[] values = new Serializable[vSet.size()];
                                vSet.toArray(values);
                                DHT.PutRequest[] reqs = new DHT.PutRequest[]{new DHT.PutRequest<Serializable>(key, values)};
                                if (ChurnTolerantDHTImpl.this.config.getRootDoesReplication()) {
                                    numReplica = ChurnTolerantDHTImpl.this.config.getNumReplica();
                                    repeat = 1;
                                } else {
                                    numReplica = 1;
                                    repeat = ChurnTolerantDHTImpl.this.config.getNumReplica();
                                }
                                Set<ValueInfo<V>>[] ret = ChurnTolerantDHTImpl.this.putOrRemoveRemotely(reqs, false, attr.getTTL(), attr.getHashedSecret(), false, numReplica, repeat, false);
                                for (int i = 0; i < reqs.length; ++i) {
                                    if (ret[i] != null) continue;
                                    BasicDHTImpl.logger.log(Level.WARNING, "put() failed: " + reqs[i].getKey());
                                }
                            }
                        }
                    }
                    double playRatio = ChurnTolerantDHTImpl.this.config.getReputIntervalPlayRatio();
                    double intervalRatio = 1.0 - playRatio + playRatio * 2.0 * this.rnd.nextDouble();
                    long sleepPeriod = (long)((double)ChurnTolerantDHTImpl.this.config.getReputInterval() * intervalRatio);
                    if (ChurnTolerantDHTImpl.this.config.getUseTimerInsteadOfThread()) {
                        timer.schedule(this, System.currentTimeMillis() + sleepPeriod, true);
                        return;
                    }
                    Thread.sleep(sleepPeriod);
                }
            }
            catch (InterruptedException e) {
                BasicDHTImpl.logger.log(Level.WARNING, "Reputter interrupted and die.", e);
            }
        }
    }

    private class PutValueInfoMessageHandler
    implements MessageHandler {
        private PutValueInfoMessageHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message process(Message msg) {
            Serializable[] contents = msg.getContents();
            Map valueMap = (Map)((Object)contents[0]);
            if (valueMap != null) {
                for (Map.Entry entry : valueMap.entrySet()) {
                    ID key = (ID)entry.getKey();
                    Set valSet = (Set)entry.getValue();
                    for (ValueInfo val : valSet) {
                        try {
                            MultiValueDirectory multiValueDirectory = ChurnTolerantDHTImpl.this.globalDir;
                            synchronized (multiValueDirectory) {
                                ChurnTolerantDHTImpl.this.globalDir.put(key, val, val.getTTL());
                            }
                        }
                        catch (Exception e) {
                        }
                    }
                }
            }
            return null;
        }
    }

    private class RemoveMessageHandler
    extends BasicDHTImpl.RemoveMessageHandler {
        private RemoveMessageHandler() {
        }

        public Message process(Message msg) {
            ByteArray hashedSecret;
            DHT.RemoveRequest[] requests;
            Set<ValueInfo<V>>[] existedValue;
            Message resultMsg = super.process(msg);
            Serializable[] contents = msg.getContents();
            int numReplica = (Integer)contents[2];
            Set[] ret = (Set[])resultMsg.getContents()[0];
            if (numReplica > 1 && (existedValue = ChurnTolerantDHTImpl.this.putOrRemoveRemotely(requests = (DHT.RemoveRequest[])contents[0], true, 0L, hashedSecret = (ByteArray)contents[1], false, 1, numReplica - 1, true)) != null) {
                for (int i = 0; i < requests.length; ++i) {
                    Set s = existedValue[i];
                    if (s == null) continue;
                    if (ret[i] == null) {
                        ret[i] = new HashSet();
                    }
                    ret[i].addAll(s);
                }
            }
            return resultMsg;
        }
    }

    protected class PutMessageHandler
    extends BasicDHTImpl.PutMessageHandler {
        protected PutMessageHandler() {
        }

        public Message process(Message msg) {
            ByteArray hashedSecret;
            long ttl;
            DHT.PutRequest[] requests;
            Set<ValueInfo<V>>[] existedValue;
            Message resultMsg = super.process(msg);
            Serializable[] contents = msg.getContents();
            int numReplica = (Integer)contents[3];
            Set[] ret = (Set[])resultMsg.getContents()[0];
            if (numReplica > 1 && (existedValue = ChurnTolerantDHTImpl.this.putOrRemoveRemotely(requests = (DHT.PutRequest[])contents[0], false, ttl = ((Long)contents[1]).longValue(), hashedSecret = (ByteArray)contents[2], false, 1, numReplica - 1, true)) != null) {
                for (int i = 0; i < requests.length; ++i) {
                    Set s = existedValue[i];
                    if (s == null) continue;
                    if (ret[i] == null) {
                        ret[i] = new HashSet();
                    }
                    ret[i].addAll(s);
                }
            }
            return resultMsg;
        }
    }
}

