/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockAttemptResult;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockManager;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DummyLockManager
extends LockManager {
    private LockManager superiorLockManager;

    public DummyLockManager(EnvironmentImpl envImpl, LockManager superiorLockManager) throws DatabaseException {
        super(envImpl);
        this.superiorLockManager = superiorLockManager;
    }

    @Override
    protected Lock lookupLock(Long nodeId) throws DatabaseException {
        Lock ret = this.superiorLockManager.lookupLock(nodeId);
        return ret;
    }

    @Override
    protected LockAttemptResult attemptLock(Long nodeId, Locker locker, LockType type, boolean nonBlockingRequest) throws DatabaseException {
        if (locker.isTransactional()) {
            return this.superiorLockManager.attemptLock(nodeId, locker, type, nonBlockingRequest);
        }
        return new LockAttemptResult(null, LockGrantType.NEW, true);
    }

    @Override
    protected DeadlockException makeTimeoutMsg(String lockOrTxn, Locker locker, long nodeId, LockType type, LockGrantType grantType, Lock useLock, long timeout, long start, long now, DatabaseImpl database) throws DatabaseException {
        if (locker.isTransactional()) {
            return this.superiorLockManager.makeTimeoutMsg(lockOrTxn, locker, nodeId, type, grantType, useLock, timeout, start, now, database);
        }
        return null;
    }

    @Override
    protected Set<Locker> releaseAndFindNotifyTargets(long nodeId, Locker locker) throws DatabaseException {
        if (locker.isTransactional()) {
            return this.superiorLockManager.releaseAndFindNotifyTargets(nodeId, locker);
        }
        return null;
    }

    @Override
    void transfer(long nodeId, Locker owningLocker, Locker destLocker, boolean demoteToRead) throws DatabaseException {
        if (!owningLocker.isTransactional()) {
            return;
        }
        this.superiorLockManager.transfer(nodeId, owningLocker, destLocker, demoteToRead);
    }

    @Override
    void transferMultiple(long nodeId, Locker owningLocker, Locker[] destLockers) throws DatabaseException {
        if (!owningLocker.isTransactional()) {
            return;
        }
        this.superiorLockManager.transferMultiple(nodeId, owningLocker, destLockers);
    }

    @Override
    void demote(long nodeId, Locker locker) throws DatabaseException {
        if (!locker.isTransactional()) {
            return;
        }
        this.superiorLockManager.demote(nodeId, locker);
    }

    @Override
    boolean isLocked(Long nodeId) throws DatabaseException {
        return this.superiorLockManager.isLocked(nodeId);
    }

    @Override
    boolean isOwner(Long nodeId, Locker locker, LockType type) throws DatabaseException {
        return this.superiorLockManager.isOwner(nodeId, locker, type);
    }

    @Override
    boolean isWaiter(Long nodeId, Locker locker) throws DatabaseException {
        return this.superiorLockManager.isWaiter(nodeId, locker);
    }

    @Override
    int nWaiters(Long nodeId) throws DatabaseException {
        return this.superiorLockManager.nWaiters(nodeId);
    }

    @Override
    int nOwners(Long nodeId) throws DatabaseException {
        return this.superiorLockManager.nOwners(nodeId);
    }

    @Override
    Locker getWriteOwnerLocker(Long nodeId) throws DatabaseException {
        return this.superiorLockManager.getWriteOwnerLocker(nodeId);
    }

    @Override
    protected boolean validateOwnership(Long nodeId, Locker locker, LockType type, boolean flushFromWaiters, MemoryBudget mb) throws DatabaseException {
        if (locker.isTransactional()) {
            return this.superiorLockManager.validateOwnership(nodeId, locker, type, flushFromWaiters, mb);
        }
        return true;
    }

    @Override
    protected void dumpLockTable(LockStats stats) throws DatabaseException {
        this.superiorLockManager.dumpLockTable(stats);
    }
}

