/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.query;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.TemporalType;
import org.seasar.extension.jdbc.ParamType;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.Query;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.SqlLog;
import org.seasar.extension.jdbc.SqlLogRegistry;
import org.seasar.extension.jdbc.SqlLogRegistryLocator;
import org.seasar.extension.jdbc.SqlLogger;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.exception.QueryTwiceExecutionRuntimeException;
import org.seasar.extension.jdbc.impl.SqlLogImpl;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.parameter.LobParameter;
import org.seasar.extension.jdbc.parameter.TemporalParameter;
import org.seasar.extension.jdbc.query.Param;
import org.seasar.extension.jdbc.util.BindVariableUtil;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ResultSetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQuery<S extends Query<S>>
implements Query<S>,
SqlLogger {
    protected JdbcManagerImplementor jdbcManager;
    protected Class<?> callerClass;
    protected String callerMethodName;
    protected int queryTimeout;
    protected Logger logger;
    protected String executedSql;
    protected List<Param> paramList = new ArrayList<Param>();
    protected boolean completed;

    public AbstractQuery(JdbcManagerImplementor jdbcManager) {
        this.jdbcManager = jdbcManager;
    }

    @Override
    public S callerClass(Class<?> callerClass) {
        this.callerClass = callerClass;
        return (S)this;
    }

    @Override
    public S callerMethodName(String callerMethodName) {
        this.callerMethodName = callerMethodName;
        return (S)this;
    }

    @Override
    public S queryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
        return (S)this;
    }

    @Override
    public void logSql(String sql, Object ... vars) {
        SqlLogRegistry sqlLogRegistry;
        String completeSql = null;
        if (this.logger.isDebugEnabled()) {
            completeSql = BindVariableUtil.getCompleteSql((String)sql, (Object[])vars);
            this.logger.debug((Object)completeSql);
        }
        if ((sqlLogRegistry = SqlLogRegistryLocator.getInstance()) != null) {
            if (completeSql == null) {
                completeSql = BindVariableUtil.getCompleteSql((String)sql, (Object[])vars);
            }
            Class[] classes = new Class[vars.length];
            for (int i = 0; i < vars.length; ++i) {
                classes[i] = vars[i].getClass();
            }
            SqlLogImpl sqlLog = new SqlLogImpl(sql, completeSql, vars, classes);
            sqlLogRegistry.add((SqlLog)sqlLog);
        }
    }

    protected abstract void prepare(String var1);

    protected void logSql() {
        SqlLogRegistry sqlLogRegistry;
        String completeSql = null;
        Object[] vars = null;
        ValueType[] valueTypes = null;
        if (this.logger.isDebugEnabled()) {
            vars = this.getParamValues();
            valueTypes = this.getParamValueTypes();
            completeSql = BindVariableUtil.getCompleteSql((String)this.executedSql, (Object[])vars, (ValueType[])valueTypes);
            this.logger.debug((Object)completeSql);
        }
        if ((sqlLogRegistry = SqlLogRegistryLocator.getInstance()) != null) {
            if (completeSql == null) {
                vars = this.getParamValues();
                valueTypes = this.getParamValueTypes();
                completeSql = BindVariableUtil.getCompleteSql((String)this.executedSql, (Object[])vars, (ValueType[])valueTypes);
            }
            SqlLogImpl sqlLog = new SqlLogImpl(this.executedSql, completeSql, vars, (Class[])this.getParamClasses());
            sqlLogRegistry.add((SqlLog)sqlLog);
        }
    }

    protected void prepareCallerClassAndMethodName(String methodName) {
        this.assertNotCompleted(methodName);
        if (this.callerClass == null) {
            this.callerClass = this.getClass();
        }
        this.logger = Logger.getLogger(this.callerClass);
        if (this.callerMethodName == null) {
            this.callerMethodName = methodName;
        }
    }

    public JdbcManagerImplementor getJdbcManager() {
        return this.jdbcManager;
    }

    public String getExecutedSql() {
        return this.executedSql;
    }

    public Object[] getParamValues() {
        Object[] ret = new Object[this.paramList.size()];
        for (int i = 0; i < this.paramList.size(); ++i) {
            ret[i] = this.paramList.get((int)i).value;
        }
        return ret;
    }

    public Class<?>[] getParamClasses() {
        Class[] ret = new Class[this.paramList.size()];
        for (int i = 0; i < this.paramList.size(); ++i) {
            ret[i] = this.paramList.get((int)i).paramClass;
        }
        return ret;
    }

    public ValueType[] getParamValueTypes() {
        ValueType[] ret = new ValueType[this.paramList.size()];
        for (int i = 0; i < this.paramList.size(); ++i) {
            ret[i] = this.paramList.get((int)i).valueType;
        }
        return ret;
    }

    public Class<?> getCallerClass() {
        return this.callerClass;
    }

    public String getCallerMethodName() {
        return this.callerMethodName;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    protected Param getParam(int index) {
        return this.paramList.get(index);
    }

    protected int getParamSize() {
        return this.paramList.size();
    }

    protected Param addParam(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.addParam(value, value.getClass());
    }

    protected Param addParam(Object value, PropertyMeta propertyMeta) {
        if (propertyMeta == null) {
            throw new NullPointerException("propertyMeta");
        }
        ValueType valueType = this.jdbcManager.getDialect().getValueType(propertyMeta);
        return this.addParam(value, propertyMeta.getPropertyClass(), valueType);
    }

    protected Param addParam(Object value, Class<?> paramClass) {
        if (paramClass == null) {
            throw new NullPointerException("paramClass");
        }
        Param param = new Param();
        if (value instanceof TemporalParameter) {
            TemporalParameter parameter = (TemporalParameter)TemporalParameter.class.cast(value);
            param.value = parameter.getValue();
            param.paramClass = parameter.getTemporalClass();
            param.valueType = this.getValueType(param.paramClass, false, parameter.getTemporalType());
        } else if (value instanceof LobParameter) {
            LobParameter parameter = (LobParameter)LobParameter.class.cast(value);
            param.value = parameter.getValue();
            param.paramClass = parameter.getLobClass();
            param.valueType = this.getValueType(param.paramClass, true, null);
        } else {
            param.value = value;
            param.paramClass = paramClass;
            param.valueType = this.getValueType(param.paramClass, false, null);
        }
        this.paramList.add(param);
        return param;
    }

    protected Param addParam(Object value, Class<?> paramClass, ValueType valueType) {
        Param param = new Param(value, paramClass);
        param.valueType = valueType;
        this.paramList.add(param);
        return param;
    }

    protected ValueType getValueType(Class<?> paramClass, boolean lob, TemporalType temporalType) {
        return this.jdbcManager.getDialect().getValueType(paramClass, lob, temporalType);
    }

    protected void prepareInParams(PreparedStatement ps) {
        int size = this.paramList.size();
        try {
            for (int i = 0; i < size; ++i) {
                Param param = this.paramList.get(i);
                if (param.paramType == ParamType.OUT) continue;
                param.valueType.bindValue(ps, i + 1, param.value);
            }
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    protected void resetParams() {
        this.paramList.clear();
    }

    protected Object handleResultSet(ResultSetHandler handler, ResultSet rs) throws SQLRuntimeException {
        Object ret = null;
        try {
            ret = handler.handle(rs);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        finally {
            ResultSetUtil.close((ResultSet)rs);
        }
        return ret;
    }

    protected String[] toStringArray(CharSequence ... names) {
        String[] result = new String[names.length];
        for (int i = 0; i < result.length; ++i) {
            CharSequence name = names[i];
            result[i] = name == null ? null : ((Object)name).toString();
        }
        return result;
    }

    protected void assertNotCompleted(String methodName) {
        if (this.completed) {
            throw new QueryTwiceExecutionRuntimeException(this.getClass(), methodName);
        }
    }

    protected void completed() {
        this.completed = true;
    }
}

